/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.command;

import java.io.Serializable;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.fastagi.command.AgiCommand;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class AbstractAgiCommand
implements Serializable,
AgiCommand {
    private static final long serialVersionUID = 3257849874518456633L;
    private AsteriskVersion asteriskVersion;
    private static final Log logger = LogFactory.getLog(AbstractAgiCommand.class);

    @Override
    public abstract String buildCommand();

    protected String escapeAndQuote(String s) {
        if (s == null) {
            return "\"\"";
        }
        String tmp = s;
        tmp = tmp.replaceAll("\\\\", "\\\\\\\\");
        tmp = tmp.replaceAll("\\\"", "\\\\\"");
        tmp = tmp.replaceAll("\\\n", "");
        return "\"" + tmp + "\"";
    }

    protected String escapeAndQuote(String[] options) {
        if (options == null) {
            return this.escapeAndQuote((String)null);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < options.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(options[i]);
        }
        return this.escapeAndQuote(sb.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName()).append("[");
        sb.append("command='").append(this.buildCommand()).append("', ");
        sb.append("systemHashcode=").append(System.identityHashCode(this)).append("]");
        return sb.toString();
    }

    @Override
    public void setAsteriskVersion(AsteriskVersion asteriskVersion) {
        this.asteriskVersion = asteriskVersion;
    }

    AsteriskVersion getAsteriskVersion() {
        if (this.asteriskVersion == null) {
            logger.warn("Asterisk Version isn't known, returning 1.4");
            return AsteriskVersion.ASTERISK_1_4;
        }
        return this.asteriskVersion;
    }
}

