/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.loader;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.features.AbstractFeature;
import org.biojava.nbio.core.sequence.features.DBReferenceInfo;
import org.biojava.nbio.core.sequence.features.DatabaseReferenceInterface;
import org.biojava.nbio.core.sequence.features.FeatureRetriever;
import org.biojava.nbio.core.sequence.features.FeaturesKeyWordInterface;
import org.biojava.nbio.core.sequence.io.GenbankSequenceParser;
import org.biojava.nbio.core.sequence.io.GenericGenbankHeaderParser;
import org.biojava.nbio.core.sequence.loader.StringProxySequenceReader;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenbankProxySequenceReader<C extends Compound>
extends StringProxySequenceReader<C>
implements FeaturesKeyWordInterface,
DatabaseReferenceInterface,
FeatureRetriever {
    private static final Logger logger = LoggerFactory.getLogger(GenbankProxySequenceReader.class);
    private static final String eutilBaseURL = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/";
    private String genbankDirectoryCache = null;
    private GenbankSequenceParser<AbstractSequence<C>, C> genbankParser;
    private GenericGenbankHeaderParser<AbstractSequence<C>, C> headerParser;
    private String header;
    private HashMap<String, ArrayList<AbstractFeature>> features;

    public GenbankProxySequenceReader(String genbankDirectoryCache, String accessionID, CompoundSet<C> compoundSet) throws IOException, InterruptedException, CompoundNotFoundException {
        this.setGenbankDirectoryCache(genbankDirectoryCache);
        this.setCompoundSet(compoundSet);
        String db = compoundSet instanceof AminoAcidCompoundSet ? "protein" : "nuccore";
        BufferedInputStream inStream = this.getBufferedInputStream(accessionID, db);
        this.genbankParser = new GenbankSequenceParser();
        this.setContents(this.genbankParser.getSequence(new BufferedReader(new InputStreamReader(inStream)), 0));
        this.headerParser = this.genbankParser.getSequenceHeaderParser();
        this.header = this.genbankParser.getHeader();
        this.features = this.genbankParser.getFeatures();
        if (compoundSet.getClass().equals(AminoAcidCompoundSet.class) && !this.genbankParser.getCompoundType().equals(compoundSet)) {
            logger.error("Declared compount type {} does not mach the real: {}", (Object)this.genbankParser.getCompoundType().toString(), (Object)compoundSet.toString());
            throw new IOException("Wrong declared compound type for: " + accessionID);
        }
        ((InputStream)inStream).close();
    }

    private BufferedInputStream getBufferedInputStream(String accessionID, String db) throws IOException, InterruptedException {
        BufferedInputStream inStream = null;
        if (this.genbankDirectoryCache != null && this.genbankDirectoryCache.length() > 0) {
            File f = new File(this.genbankDirectoryCache + File.separatorChar + accessionID + ".gb");
            if (f.exists()) {
                logger.debug("Reading: {}", (Object)f.toString());
                inStream = new BufferedInputStream(new FileInputStream(f));
            } else {
                InputStream in = this.getEutilsInputStream(accessionID, db);
                this.copyInputStreamToFile(in, f);
                inStream = new BufferedInputStream(new FileInputStream(f));
            }
        } else {
            inStream = new BufferedInputStream(this.getEutilsInputStream(accessionID, db));
        }
        return inStream;
    }

    private void copyInputStreamToFile(InputStream in, File f) throws IOException, InterruptedException {
        FileOutputStream out = new FileOutputStream(f);
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len != -1) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
            if (!Thread.interrupted()) continue;
            in.close();
            out.close();
            throw new InterruptedException();
        }
        in.close();
        out.close();
    }

    private InputStream getEutilsInputStream(String accessionID, String db) throws IOException {
        String genbankURL = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=" + db + "&id=" + accessionID + "&rettype=gb&retmode=text";
        logger.trace("Loading: {}", (Object)genbankURL);
        URL genbank = new URL(genbankURL);
        URLConnection genbankConnection = genbank.openConnection();
        return genbankConnection.getInputStream();
    }

    public String getGenbankDirectoryCache() {
        return this.genbankDirectoryCache;
    }

    public void setGenbankDirectoryCache(String genbankDirectoryCache) {
        File f;
        if (genbankDirectoryCache != null && !(f = new File(genbankDirectoryCache)).exists()) {
            f.mkdirs();
        }
        this.genbankDirectoryCache = genbankDirectoryCache;
    }

    public String getHeader() {
        return this.header;
    }

    public GenericGenbankHeaderParser<AbstractSequence<C>, C> getHeaderParser() {
        return this.headerParser;
    }

    @Override
    public HashMap<String, ArrayList<AbstractFeature>> getFeatures() {
        return this.features;
    }

    @Override
    public LinkedHashMap<String, ArrayList<DBReferenceInfo>> getDatabaseReferences() {
        return this.genbankParser.getDatabaseReferences();
    }

    @Override
    public ArrayList<String> getKeyWords() {
        return this.genbankParser.getKeyWords();
    }

    public static void main(String[] args) throws Throwable {
        GenbankProxySequenceReader<AminoAcidCompound> genbankProteinReader = new GenbankProxySequenceReader<AminoAcidCompound>("/tmp", "NP_000257", AminoAcidCompoundSet.getAminoAcidCompoundSet());
        ProteinSequence proteinSequence = new ProteinSequence(genbankProteinReader);
        genbankProteinReader.getHeaderParser().parseHeader(genbankProteinReader.getHeader(), proteinSequence);
        logger.info("Sequence ({},{})={}...", new Object[]{proteinSequence.getAccession(), proteinSequence.getLength(), proteinSequence.getSequenceAsString().substring(0, 10)});
        logger.info("Keywords: {}", genbankProteinReader.getKeyWords());
        logger.info("DatabaseReferences: {}", genbankProteinReader.getDatabaseReferences());
        proteinSequence.getFeatures();
        GenbankProxySequenceReader<NucleotideCompound> genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "NM_001126", DNACompoundSet.getDNACompoundSet());
        DNASequence dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        dnaSequence.setAccession(new AccessionID("NM_001126"));
        logger.info("Sequence ({},{})={}...", new Object[]{dnaSequence.getAccession(), dnaSequence.getLength(), dnaSequence.getSequenceAsString().substring(0, 10)});
        logger.info("Keywords: {}", genbankDNAReader.getKeyWords());
        logger.info("DatabaseReferences: {}", genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "NM_000266", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        logger.info("Sequence ({},{})={}...", new Object[]{dnaSequence.getAccession(), dnaSequence.getLength(), dnaSequence.getSequenceAsString().substring(0, 10)});
        logger.info("Keywords: {}", genbankDNAReader.getKeyWords());
        logger.info("DatabaseReferences: {}", genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "AV254721", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        logger.info("Sequence ({},{})={}...", new Object[]{dnaSequence.getAccession(), dnaSequence.getLength(), dnaSequence.getSequenceAsString().substring(0, 10)});
        logger.info("Keywords: {}", genbankDNAReader.getKeyWords());
        logger.info("DatabaseReferences: {}", genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "AV254721.2", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        logger.info("Sequence ({},{})={}...", new Object[]{dnaSequence.getAccession(), dnaSequence.getLength(), dnaSequence.getSequenceAsString().substring(0, 10)});
        logger.info("Keywords: {}", genbankDNAReader.getKeyWords());
        logger.info("DatabaseReferences: {}", genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "U49845", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        logger.info("Sequence ({},{})={}...", new Object[]{dnaSequence.getAccession(), dnaSequence.getLength(), dnaSequence.getSequenceAsString().substring(0, 10)});
        logger.info("Keywords: {}", genbankDNAReader.getKeyWords());
        logger.info("DatabaseReferences: {}", genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "GI:1293613", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        logger.info("Sequence ({},{})={}...", new Object[]{dnaSequence.getAccession(), dnaSequence.getLength(), dnaSequence.getSequenceAsString().substring(0, 10)});
        logger.info("Keywords: {}", genbankDNAReader.getKeyWords());
        logger.info("DatabaseReferences: {}", genbankDNAReader.getDatabaseReferences());
        genbankDNAReader = new GenbankProxySequenceReader<NucleotideCompound>("/tmp", "14109166", DNACompoundSet.getDNACompoundSet());
        dnaSequence = new DNASequence(genbankDNAReader);
        genbankDNAReader.getHeaderParser().parseHeader(genbankDNAReader.getHeader(), dnaSequence);
        logger.info("Sequence ({},{})={}...", new Object[]{dnaSequence.getAccession(), dnaSequence.getLength(), dnaSequence.getSequenceAsString().substring(0, 10)});
        logger.info("Keywords: {}", genbankDNAReader.getKeyWords());
        logger.info("DatabaseReferences: {}", genbankDNAReader.getDatabaseReferences());
    }
}

