/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.core.exceptions.ParserException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.DataSource;
import org.biojava.nbio.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava.nbio.core.sequence.reference.AbstractReference;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;

public class GenericGenbankHeaderParser<S extends AbstractSequence<C>, C extends Compound>
implements SequenceHeaderParserInterface<S, C> {
    private String description;
    private String accession = null;
    private String identifier = null;
    private String name = null;
    private int version;
    private boolean versionSeen;
    private ArrayList<String> comments = new ArrayList();
    private List<AbstractReference> references = new ArrayList<AbstractReference>();
    private List<String> keywords = new ArrayList<String>();
    private String source = null;
    private List<String> organism = new ArrayList<String>();
    private String gi = null;

    @Override
    public void parseHeader(String header, S sequence) {
        ((AbstractSequence)sequence).setOriginalHeader(header);
        ((AbstractSequence)sequence).setAccession(new AccessionID(this.accession, DataSource.GENBANK, this.version, this.identifier));
        ((AbstractSequence)sequence).setDescription(this.description);
        ((AbstractSequence)sequence).setComments(this.comments);
        ((AbstractSequence)sequence).setReferences(this.references);
    }

    public String getAccession() {
        return this.accession;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public ArrayList<String> getComments() {
        return this.comments;
    }

    public List<AbstractReference> getReferences() {
        return this.references;
    }

    public String getDescription() {
        return this.description;
    }

    private void reset() {
        this.version = 0;
        this.versionSeen = false;
        this.accession = null;
        this.description = null;
        this.identifier = null;
        this.name = null;
        this.comments.clear();
    }

    public void setVersion(int version) {
        if (this.versionSeen) {
            throw new ParserException("Current BioEntry already has a version");
        }
        try {
            this.version = version;
            this.versionSeen = true;
        }
        catch (NumberFormatException e) {
            throw new ParserException("Could not parse version as an integer");
        }
    }

    public void setAccession(String accession) {
        if (accession == null) {
            throw new ParserException("Accession cannot be null");
        }
        this.accession = accession;
    }

    public void setDescription(String description) {
        if (this.description != null) {
            throw new ParserException("Current BioEntry already has a description");
        }
        this.description = description;
    }

    public void setIdentifier(String identifier) {
        if (identifier == null) {
            throw new ParserException("Identifier cannot be null");
        }
        if (this.identifier != null) {
            throw new ParserException("Current BioEntry already has a identifier");
        }
        this.identifier = identifier;
    }

    public void setName(String name) {
        if (name == null) {
            throw new ParserException("Name cannot be null");
        }
        if (this.name != null) {
            throw new ParserException("Current BioEntry already has a name");
        }
        this.name = name;
    }

    public void setComment(String comment) {
        if (comment == null) {
            throw new ParserException("Comment cannot be null");
        }
        this.comments.add(comment);
    }

    public void addReference(AbstractReference abstractReference) {
        this.references.add(abstractReference);
    }
}

