/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.io.FastaReader;
import org.biojava.nbio.core.sequence.io.GenericFastaHeaderParser;
import org.biojava.nbio.core.sequence.io.ProteinSequenceCreator;
import org.biojava.nbio.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava.nbio.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava.nbio.core.util.InputStreamProvider;

public class FastaStreamer {
    private final Path path;
    private int batchSize = 1000;
    private SequenceHeaderParserInterface<ProteinSequence, AminoAcidCompound> headerParser;
    private SequenceCreatorInterface<AminoAcidCompound> sequenceCreator;
    private LinkedHashMap<String, ProteinSequence> chunk = new LinkedHashMap();
    private Iterator<Map.Entry<String, ProteinSequence>> iterator = Collections.emptyIterator();
    private boolean closed = false;

    private FastaStreamer(Path path) {
        this.path = path;
    }

    public static FastaStreamer from(Path path) {
        return new FastaStreamer(path);
    }

    public static FastaStreamer from(File file) {
        return FastaStreamer.from(file.toPath());
    }

    public FastaStreamer withHeaderParser(SequenceHeaderParserInterface<ProteinSequence, AminoAcidCompound> headerParser) {
        this.headerParser = headerParser;
        return this;
    }

    public FastaStreamer withSequenceCreator(SequenceCreatorInterface<AminoAcidCompound> sequenceCreator) {
        this.sequenceCreator = sequenceCreator;
        return this;
    }

    public FastaStreamer batchSize(int size) {
        this.batchSize = size;
        return this;
    }

    public Iterable<ProteinSequence> each() {
        return () -> this.stream().iterator();
    }

    public Stream<ProteinSequence> stream() {
        InputStream input;
        InputStreamProvider provider = new InputStreamProvider();
        try {
            input = provider.getInputStream(this.getPath().toFile());
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
        final FastaReader<ProteinSequence, AminoAcidCompound> reader = new FastaReader<ProteinSequence, AminoAcidCompound>(input, this.getHeaderParser(), this.getSequenceCreator());
        Spliterators.AbstractSpliterator<ProteinSequence> source = new Spliterators.AbstractSpliterator<ProteinSequence>(Integer.MAX_VALUE, 1280){

            @Override
            public boolean tryAdvance(Consumer<? super ProteinSequence> action) {
                if (FastaStreamer.this.closed) {
                    return false;
                }
                ProteinSequence protein = this.next(reader);
                if (null == protein) {
                    return false;
                }
                action.accept(protein);
                return true;
            }

            private ProteinSequence next(FastaReader<ProteinSequence, AminoAcidCompound> reader2) {
                try {
                    if (!FastaStreamer.this.iterator.hasNext()) {
                        FastaStreamer.this.chunk = reader2.process(FastaStreamer.this.getBatchSize());
                        if (null == FastaStreamer.this.chunk) {
                            FastaStreamer.this.closed = true;
                            reader2.close();
                            return null;
                        }
                        FastaStreamer.this.iterator = FastaStreamer.this.chunk.entrySet().iterator();
                    }
                    if (FastaStreamer.this.iterator.hasNext()) {
                        Map.Entry<String, ProteinSequence> entry = FastaStreamer.this.iterator.next();
                        return FastaStreamer.this.createSequence(entry.getValue());
                    }
                    FastaStreamer.this.closed = true;
                    reader2.close();
                }
                catch (IOException exception) {
                    throw new UncheckedIOException(String.format("I/O error reading the FASTA file from '%s'", FastaStreamer.this.getPath()), exception);
                }
                return null;
            }
        };
        return StreamSupport.stream(source, false);
    }

    protected ProteinSequence createSequence(ProteinSequence sequence) {
        return sequence;
    }

    protected Path getPath() {
        return this.path;
    }

    protected int getBatchSize() {
        return this.batchSize;
    }

    protected SequenceHeaderParserInterface<ProteinSequence, AminoAcidCompound> getHeaderParser() {
        return Optional.ofNullable(this.headerParser).orElse(new GenericFastaHeaderParser());
    }

    public SequenceCreatorInterface<AminoAcidCompound> getSequenceCreator() {
        return Optional.ofNullable(this.sequenceCreator).orElse(new ProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet()));
    }
}

