/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.biojava.nbio.core.util.FlatFileCache;
import org.biojava.nbio.core.util.UncompressInputStream;

public class InputStreamProvider {
    public static final int GZIP_MAGIC = 8075;
    public static final String CACHE_PROPERTY = "biojava.cache.files";
    private boolean cacheRawFiles = false;

    public InputStreamProvider() {
        String prop = System.getProperty(CACHE_PROPERTY);
        if ("true".equals(prop)) {
            this.cacheRawFiles = true;
        }
    }

    public InputStream getInputStream(String pathToFile) throws IOException {
        File f = new File(pathToFile);
        return this.getInputStream(f);
    }

    private int getMagicNumber(InputStream in) throws IOException {
        int t = in.read();
        if (t < 0) {
            throw new EOFException("Failed to read magic number");
        }
        int magic = (t & 0xFF) << 8;
        t = in.read();
        if (t < 0) {
            throw new EOFException("Failed to read magic number");
        }
        return magic += t & 0xFF;
    }

    public InputStream getInputStream(URL u) throws IOException {
        if ("file".equals(u.getProtocol())) {
            try {
                return this.getInputStream(new File(u.toURI().getPath()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        int magic = 0;
        InputStream inStream = u.openStream();
        magic = this.getMagicNumber(inStream);
        inStream.close();
        if (magic == 8093) {
            return this.openCompressedURL(u);
        }
        if (magic == 8075) {
            return this.openGZIPURL(u);
        }
        if (u.getPath().endsWith(".gz")) {
            return this.openGZIPURL(u);
        }
        if (u.getPath().endsWith(".Z")) {
            return this.openCompressedURL(u);
        }
        inStream = u.openStream();
        return inStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream getInputStream(File f) throws IOException {
        int magic = 0;
        InputStream test = this.getInputStreamFromFile(f);
        magic = this.getMagicNumber(test);
        test.close();
        InputStream inputStream = null;
        String fileName = f.getName();
        if (magic == 8093) {
            return this.openCompressedFile(f);
        }
        if (magic == 8075) {
            return this.openGZIPFile(f);
        }
        if (fileName.endsWith(".gz")) {
            return this.openGZIPFile(f);
        }
        if (fileName.endsWith(".zip")) {
            ZipFile zipfile = new ZipFile(f);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            if (!e.hasMoreElements()) throw new IOException("Zip file has no entries");
            ZipEntry entry = e.nextElement();
            return zipfile.getInputStream(entry);
        }
        if (fileName.endsWith(".jar")) {
            JarFile jarFile = new JarFile(f);
            Enumeration<JarEntry> e = jarFile.entries();
            if (!e.hasMoreElements()) throw new IOException("Jar file has no entries");
            JarEntry entry = e.nextElement();
            return jarFile.getInputStream(entry);
        }
        if (!fileName.endsWith(".Z")) return this.getInputStreamFromFile(f);
        return this.openCompressedFile(f);
    }

    private InputStream getInputStreamFromFile(File f) throws FileNotFoundException {
        InputStream stream = null;
        if (this.cacheRawFiles && (stream = FlatFileCache.getInputStream(f.getAbsolutePath())) == null) {
            FlatFileCache.addToCache(f.getAbsolutePath(), f);
            stream = FlatFileCache.getInputStream(f.getAbsolutePath());
        }
        if (stream == null) {
            stream = new FileInputStream(f);
        }
        return stream;
    }

    private InputStream openCompressedFile(File f) throws IOException {
        InputStream is = this.getInputStreamFromFile(f);
        UncompressInputStream inputStream = new UncompressInputStream(is);
        return inputStream;
    }

    private InputStream openCompressedURL(URL u) throws IOException {
        InputStream is = u.openStream();
        UncompressInputStream inputStream = new UncompressInputStream(is);
        return inputStream;
    }

    private InputStream openGZIPFile(File f) throws IOException {
        InputStream is = this.getInputStreamFromFile(f);
        GZIPInputStream inputStream = new GZIPInputStream(is);
        return inputStream;
    }

    private InputStream openGZIPURL(URL u) throws IOException {
        InputStream is = u.openStream();
        GZIPInputStream inputStream = new GZIPInputStream(is);
        return inputStream;
    }
}

