/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.PersistentConfig;
import org.biojava.nbio.structure.align.webstart.WebStartMain;

public class ChooseDirAction
extends AbstractAction {
    JTextField textField;
    UserConfiguration config;
    public static final long serialVersionUID = 0L;

    public ChooseDirAction(JTextField textField, UserConfiguration config) {
        super("Choose");
        this.config = config;
        this.textField = textField;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        String txt = this.textField.getText();
        if (this.config == null) {
            System.out.println("config == null, calling getWebStartConfig...");
            this.config = WebStartMain.getWebStartConfig();
        }
        if (txt != null) {
            chooser.setCurrentDirectory(new File(txt));
            this.config.setPdbFilePath(txt);
            try {
                PersistentConfig webstartConfig = new PersistentConfig();
                webstartConfig.save(this.config);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        chooser.setDialogTitle("Choose directory that contains your PDB files");
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            this.textField.setText(file.getAbsolutePath());
            this.textField.repaint();
        }
    }
}

