/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.biojava.nbio.structure.align.gui.AboutDialog;
import org.biojava.nbio.structure.align.gui.AlignmentGui;
import org.biojava.nbio.structure.align.gui.ConfigPDBInstallPanel;
import org.biojava.nbio.structure.align.gui.DBResultTable;
import org.biojava.nbio.structure.align.gui.DotPlotPanel;
import org.biojava.nbio.structure.align.gui.HelpDialog;
import org.biojava.nbio.structure.align.gui.MemoryMonitor;
import org.biojava.nbio.structure.align.gui.MyAlignmentLoadListener;
import org.biojava.nbio.structure.align.gui.MyDistMaxListener;
import org.biojava.nbio.structure.align.gui.MyExportListener;
import org.biojava.nbio.structure.align.gui.MyOpenPdbFileListener;
import org.biojava.nbio.structure.align.gui.MySaveFileListener;
import org.biojava.nbio.structure.align.gui.ShowPDBIDListener;
import org.biojava.nbio.structure.align.gui.SystemInfo;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.WebStartMain;

public class MenuCreator {
    public static final String PRINT = "Print";
    public static final String ALIGNMENT_PANEL = "Alignment Panel";
    public static final String TEXT_ONLY = "View Text Only";
    public static final String PAIRS_ONLY = "View Aligned Pairs";
    public static final String SELECT_EQR = "Select Equivalent Positions";
    public static final String SIMILARITY_COLOR = "Color By Similarity";
    public static final String EQR_COLOR = "Color By EQR";
    public static final String FATCAT_BLOCK = "Color By Alignment Block";
    public static final String LOAD_DB_RESULTS = "Load DB search results";
    public static final String SAVE_ALIGNMENT_XML = "Save Alignment XML";
    public static final String LOAD_ALIGNMENT_XML = "Load Alignment XML";
    public static final String FATCAT_TEXT = "View as FATCAT result";
    public static final String FASTA_FORMAT = "View FASTA Alignment";
    public static final String DIST_MATRICES = "Show Distance Matrices";
    public static final String DOT_PLOT = "Show Dot Plot";
    public static final String PAIRWISE_ALIGN = "New Pairwise Alignment";
    public static final String MULTIPLE_ALIGN = "New Multiple Alignment";
    protected static final int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public static JMenuBar initJmolMenu(JFrame frame, AbstractAlignmentJmol parent, AFPChain afpChain) {
        JMenuBar menu = new JMenuBar();
        JMenu file = new JMenu("File");
        file.setMnemonic(70);
        file.getAccessibleContext().setAccessibleDescription("File Menu");
        if (parent != null) {
            JMenuItem loadF = MenuCreator.getLoadMenuItem();
            loadF.addActionListener(new MyAlignmentLoadListener(parent));
            file.add(loadF);
        }
        JMenuItem saveF = MenuCreator.getSaveAlignmentMenuItem(afpChain);
        file.add(saveF);
        JMenuItem openPDB = MenuCreator.getShowPDBMenuItem();
        file.add(openPDB);
        JMenuItem openI = MenuCreator.getOpenPDBMenuItem();
        file.add(openI);
        if (parent != null) {
            JMenuItem exportI = MenuCreator.getExportPDBMenuItem(parent);
            file.add(exportI);
        }
        JMenuItem openDBI = MenuCreator.getDBResultMenuItem();
        file.add(openDBI);
        file.addSeparator();
        if (parent != null) {
            JMenuItem print = MenuCreator.getPrintMenuItem();
            print.addActionListener(parent.getJmolPanel());
            file.add(print);
        }
        file.addSeparator();
        JMenuItem closeI = MenuCreator.getCloseMenuItem(frame);
        file.add(closeI);
        JMenuItem exitI = MenuCreator.getExitMenuItem();
        file.add(exitI);
        menu.add(file);
        JMenu align = new JMenu("Align");
        align.setMnemonic(65);
        JMenuItem pairI = MenuCreator.getPairwiseAlignmentMenuItem();
        align.add(pairI);
        menu.add(align);
        JMenu view = new JMenu("View");
        view.getAccessibleContext().setAccessibleDescription("View Menu");
        view.setMnemonic(86);
        if (parent != null) {
            JMenuItem aligpI = MenuCreator.getIcon(parent, ALIGNMENT_PANEL);
            aligpI.setMnemonic(77);
            aligpI.setAccelerator(KeyStroke.getKeyStroke(77, keyMask));
            view.add(aligpI);
            JMenuItem textI = MenuCreator.getIcon(parent, TEXT_ONLY);
            textI.setMnemonic(84);
            view.add(textI);
            JMenuItem pairsI = MenuCreator.getIcon(parent, PAIRS_ONLY);
            pairsI.setMnemonic(80);
            view.add(pairsI);
            JMenuItem textF = MenuCreator.getIcon(parent, FATCAT_TEXT);
            textF.setMnemonic(70);
            view.add(textF);
            JMenuItem distMax = new JMenuItem(DIST_MATRICES);
            distMax.setMnemonic(68);
            distMax.addActionListener(new MyDistMaxListener(parent));
            view.add(distMax);
            if (afpChain != null) {
                JMenuItem dotplot = new JMenuItem(DOT_PLOT);
                dotplot.setMnemonic(79);
                dotplot.addActionListener(new DotPlotListener(afpChain));
                view.add(dotplot);
            }
        }
        menu.add(view);
        JMenu about = new JMenu("Help");
        about.setMnemonic(72);
        JMenuItem helpM = MenuCreator.getHelpMenuItem();
        about.add(helpM);
        JMenuItem aboutM = MenuCreator.getAboutMenuItem();
        about.add(aboutM);
        menu.add(Box.createGlue());
        menu.add(about);
        return menu;
    }

    public static JMenuItem getDBResultMenuItem() {
        ImageIcon saveicon = MenuCreator.createImageIcon("/icons/kpdf.png");
        JMenuItem saveI = null;
        saveI = saveicon == null ? new JMenuItem(LOAD_DB_RESULTS) : new JMenuItem(LOAD_DB_RESULTS, saveicon);
        saveI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showOpenDialog(null);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    UserConfiguration config = WebStartMain.getWebStartConfig();
                    DBResultTable table = new DBResultTable();
                    table.show(file, config);
                }
            }
        });
        return saveI;
    }

    public static JMenuItem getShowPDBMenuItem() {
        ImageIcon loadI = MenuCreator.createImageIcon("/icons/background.png");
        JMenuItem openI = null;
        openI = loadI == null ? new JMenuItem("Show By ID") : new JMenuItem("Show By ID", loadI);
        openI.setMnemonic(79);
        openI.setAccelerator(KeyStroke.getKeyStroke(79, keyMask));
        openI.addActionListener(new ShowPDBIDListener());
        return openI;
    }

    public static JMenuItem getOpenPDBMenuItem() {
        ImageIcon loadI = MenuCreator.createImageIcon("/icons/background.png");
        JMenuItem openI = null;
        openI = loadI == null ? new JMenuItem("Open PDB file") : new JMenuItem("Open PDB file", loadI);
        openI.setMnemonic(70);
        openI.addActionListener(new MyOpenPdbFileListener());
        return openI;
    }

    public static JMenuItem getLoadMenuItem() {
        JMenuItem loadF = null;
        ImageIcon loadI = MenuCreator.createImageIcon("/icons/revert.png");
        loadF = loadI == null ? new JMenuItem(LOAD_ALIGNMENT_XML) : new JMenuItem(LOAD_ALIGNMENT_XML, loadI);
        loadF.setMnemonic(76);
        loadF.setAccelerator(KeyStroke.getKeyStroke(76, keyMask));
        return loadF;
    }

    public static JMenuBar getAlignmentPanelMenu(JFrame frame, ActionListener actionListener, AFPChain afpChain) {
        JMenuBar menu = new JMenuBar();
        JMenu file = new JMenu("File");
        file.getAccessibleContext().setAccessibleDescription("File Menu");
        menu.add(file);
        ImageIcon saveicon = MenuCreator.createImageIcon("/icons/filesave.png");
        JMenuItem saveF = null;
        saveF = saveicon != null ? new JMenuItem("Save text display", saveicon) : new JMenuItem("Save text display");
        saveF.setMnemonic(83);
        MySaveFileListener listener = new MySaveFileListener(afpChain);
        listener.setFatCatOutput(true);
        saveF.addActionListener(listener);
        file.add(saveF);
        file.addSeparator();
        JMenuItem print = MenuCreator.getPrintMenuItem();
        print.addActionListener(actionListener);
        file.add(print);
        file.addSeparator();
        JMenuItem closeI = MenuCreator.getCloseMenuItem(frame);
        file.add(closeI);
        JMenuItem exitI = MenuCreator.getExitMenuItem();
        file.add(exitI);
        JMenu edit = new JMenu("Edit");
        edit.setMnemonic(69);
        menu.add(edit);
        JMenuItem eqrI = MenuCreator.getIcon(actionListener, SELECT_EQR);
        edit.add(eqrI);
        JMenuItem eqrcI = MenuCreator.getIcon(actionListener, EQR_COLOR);
        edit.add(eqrcI);
        JMenuItem simI = MenuCreator.getIcon(actionListener, SIMILARITY_COLOR);
        edit.add(simI);
        JMenuItem fatcatI = MenuCreator.getIcon(actionListener, FATCAT_BLOCK);
        edit.add(fatcatI);
        JMenu view = new JMenu("View");
        view.getAccessibleContext().setAccessibleDescription("View Menu");
        view.setMnemonic(86);
        menu.add(view);
        JMenuItem textI = MenuCreator.getIcon(actionListener, TEXT_ONLY);
        view.add(textI);
        JMenuItem fastaI = MenuCreator.getIcon(actionListener, FASTA_FORMAT);
        view.add(fastaI);
        JMenuItem pairsI = MenuCreator.getIcon(actionListener, PAIRS_ONLY);
        view.add(pairsI);
        JMenuItem textF = MenuCreator.getIcon(actionListener, FATCAT_TEXT);
        view.add(textF);
        JMenu about = new JMenu("Help");
        about.setMnemonic(65);
        JMenuItem helpM = MenuCreator.getHelpMenuItem();
        about.add(helpM);
        JMenuItem aboutM = MenuCreator.getAboutMenuItem();
        about.add(aboutM);
        menu.add(Box.createGlue());
        menu.add(about);
        return menu;
    }

    public static JMenuBar getAlignmentTextMenu(JFrame frame, ActionListener actionListener, AFPChain afpChain) {
        JMenuBar menu = new JMenuBar();
        JMenu file = new JMenu("File");
        file.getAccessibleContext().setAccessibleDescription("File Menu");
        menu.add(file);
        ImageIcon saveicon = MenuCreator.createImageIcon("/icons/filesave.png");
        JMenuItem saveF = null;
        saveF = saveicon != null ? new JMenuItem("Save text display", saveicon) : new JMenuItem("Save text display");
        saveF.setMnemonic(83);
        MySaveFileListener listener = new MySaveFileListener(afpChain);
        listener.setFatCatOutput(true);
        saveF.addActionListener(listener);
        file.add(saveF);
        file.addSeparator();
        JMenuItem print = MenuCreator.getPrintMenuItem();
        print.addActionListener(actionListener);
        file.add(print);
        file.addSeparator();
        JMenuItem closeI = MenuCreator.getCloseMenuItem(frame);
        file.add(closeI);
        JMenuItem exitI = MenuCreator.getExitMenuItem();
        file.add(exitI);
        JMenu view = new JMenu("View");
        view.getAccessibleContext().setAccessibleDescription("View Menu");
        view.setMnemonic(86);
        menu.add(view);
        JMenuItem textI = MenuCreator.getIcon(actionListener, TEXT_ONLY);
        view.add(textI);
        JMenuItem fastaI = MenuCreator.getIcon(actionListener, FASTA_FORMAT);
        view.add(fastaI);
        JMenuItem pairsI = MenuCreator.getIcon(actionListener, PAIRS_ONLY);
        view.add(pairsI);
        JMenuItem textF = MenuCreator.getIcon(actionListener, FATCAT_TEXT);
        view.add(textF);
        JMenu about = new JMenu("Help");
        about.setMnemonic(65);
        JMenuItem helpM = MenuCreator.getHelpMenuItem();
        about.add(helpM);
        JMenuItem aboutM = MenuCreator.getAboutMenuItem();
        about.add(aboutM);
        menu.add(Box.createGlue());
        menu.add(about);
        return menu;
    }

    protected static JMenuItem getIcon(ActionListener actionListener, String text) {
        JMenuItem to = new JMenuItem(text);
        to.setMnemonic(69);
        to.addActionListener(actionListener);
        return to;
    }

    public static JMenuItem getPrintMenuItem() {
        ImageIcon printIcon = MenuCreator.createImageIcon("/icons/fileprint.png");
        JMenuItem print = printIcon == null ? new JMenuItem(PRINT) : new JMenuItem(PRINT, printIcon);
        print.setMnemonic(80);
        print.setAccelerator(KeyStroke.getKeyStroke(80, keyMask));
        return print;
    }

    public static JMenuItem getExportPDBMenuItem(AbstractAlignmentJmol parent) {
        ImageIcon saveicon = MenuCreator.createImageIcon("/icons/compfile.png");
        JMenuItem exportI = null;
        exportI = saveicon == null ? new JMenuItem("Export PDB file") : new JMenuItem("Export PDB file", saveicon);
        exportI.setMnemonic(69);
        exportI.setAccelerator(KeyStroke.getKeyStroke(69, keyMask));
        exportI.addActionListener(new MyExportListener(parent));
        return exportI;
    }

    public static JMenuItem getSaveAlignmentMenuItem(AFPChain afpChain) {
        ImageIcon saveicon = MenuCreator.createImageIcon("/icons/filesave.png");
        JMenuItem saveF = null;
        saveF = saveicon == null ? new JMenuItem(SAVE_ALIGNMENT_XML) : new JMenuItem(SAVE_ALIGNMENT_XML, saveicon);
        saveF.setMnemonic(83);
        saveF.setAccelerator(KeyStroke.getKeyStroke(83, keyMask));
        saveF.addActionListener(new MySaveFileListener(afpChain));
        return saveF;
    }

    public static JMenuItem getAboutMenuItem() {
        ImageIcon helpIcon = MenuCreator.createImageIcon("/icons/help.png");
        JMenuItem aboutM = null;
        aboutM = helpIcon == null ? new JMenuItem("About this Software") : new JMenuItem("About this Software", helpIcon);
        aboutM.setMnemonic(65);
        aboutM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCreator.showAboutDialog();
            }
        });
        return aboutM;
    }

    private static JMenuItem getSystemInfoItem() {
        ImageIcon helpIcon = MenuCreator.createImageIcon("/icons/help.png");
        JMenuItem aboutM = null;
        aboutM = helpIcon == null ? new JMenuItem("System Info") : new JMenuItem("System Info", helpIcon);
        aboutM.setMnemonic(83);
        aboutM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCreator.showSystemInfo();
            }
        });
        return aboutM;
    }

    public static JMenuItem getExitMenuItem() {
        ImageIcon exitIcon = MenuCreator.createImageIcon("/icons/exit.png");
        JMenuItem exitI = exitIcon == null ? new JMenuItem("Quit") : new JMenuItem("Quit", exitIcon);
        exitI.setMnemonic(81);
        exitI.setAccelerator(KeyStroke.getKeyStroke(81, keyMask));
        exitI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals("Quit")) {
                    System.exit(0);
                }
            }
        });
        return exitI;
    }

    public static JMenuItem getHelpMenuItem() {
        ImageIcon helpIcon = MenuCreator.createImageIcon("/icons/help.png");
        JMenuItem helpM = helpIcon == null ? new JMenuItem("Help") : new JMenuItem("Help", helpIcon);
        helpM.setMnemonic(72);
        helpM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDialog d = new HelpDialog();
                d.showDialog();
            }
        });
        return helpM;
    }

    public static JMenuItem getCloseMenuItem(JFrame frame) {
        ImageIcon closeIcon = MenuCreator.createImageIcon("/icons/editdelete.png");
        JMenuItem closeI = closeIcon == null ? new JMenuItem("Close Frame") : new JMenuItem("Close Frame", closeIcon);
        closeI.setMnemonic(67);
        closeI.setAccelerator(KeyStroke.getKeyStroke(87, keyMask));
        class MyCloseListener
        implements ActionListener {
            JFrame f;

            MyCloseListener(JFrame frame) {
                this.f = frame;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals("Close Frame")) {
                    this.f.dispose();
                }
            }
        }
        closeI.addActionListener(new MyCloseListener(frame));
        return closeI;
    }

    private static void showPairDialog() {
        AlignmentGui gui = AlignmentGui.getInstance();
        gui.setVisible(true);
    }

    public static void showAboutDialog() {
        AboutDialog dialog = new AboutDialog();
        dialog.showDialog();
    }

    public static void showSystemInfo() {
        SystemInfo dialog = new SystemInfo();
        dialog.showDialog();
    }

    public static ImageIcon createImageIcon(String path) {
        URL imgURL = MenuCreator.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    protected static JMenuItem getPairwiseAlignmentMenuItem() {
        ImageIcon alignIcon = MenuCreator.createImageIcon("/icons/window_new.png");
        JMenuItem pairI = alignIcon == null ? new JMenuItem(PAIRWISE_ALIGN) : new JMenuItem(PAIRWISE_ALIGN, alignIcon);
        pairI.setMnemonic(78);
        pairI.setAccelerator(KeyStroke.getKeyStroke(78, keyMask));
        pairI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals(MenuCreator.PAIRWISE_ALIGN)) {
                    MenuCreator.showPairDialog();
                }
            }
        });
        return pairI;
    }

    protected static JMenuItem getMultipleAlignmentMenuItem() {
        ImageIcon alignIcon = MenuCreator.createImageIcon("/icons/window_new.png");
        JMenuItem multipleI = alignIcon == null ? new JMenuItem(MULTIPLE_ALIGN) : new JMenuItem(MULTIPLE_ALIGN, alignIcon);
        multipleI.setMnemonic(78);
        multipleI.setAccelerator(KeyStroke.getKeyStroke(78, keyMask));
        multipleI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals(MenuCreator.MULTIPLE_ALIGN)) {
                    MenuCreator.showPairDialog();
                }
            }
        });
        return multipleI;
    }

    public static JMenuBar initAlignmentGUIMenu(JFrame frame) {
        JMenu file = new JMenu("File");
        file.getAccessibleContext().setAccessibleDescription("File Menu");
        JMenuItem loadF = MenuCreator.getLoadMenuItem();
        loadF.addActionListener(new MyAlignmentLoadListener(null));
        file.add(loadF);
        JMenuItem openPDB = MenuCreator.getShowPDBMenuItem();
        file.add(openPDB);
        JMenuItem openI = MenuCreator.getOpenPDBMenuItem();
        file.add(openI);
        JMenuItem dbI = MenuCreator.getDBResultMenuItem();
        file.add(dbI);
        file.addSeparator();
        JMenuItem configI = MenuCreator.getConfigMenuItem();
        file.add(configI);
        file.addSeparator();
        JMenuItem closeI = MenuCreator.getCloseMenuItem(frame);
        file.add(closeI);
        JMenuItem exitI = MenuCreator.getExitMenuItem();
        file.add(exitI);
        JMenuBar menu = new JMenuBar();
        menu.add(file);
        JMenu about = new JMenu("Help");
        about.setMnemonic(65);
        JMenuItem aboutM = MenuCreator.getAboutMenuItem();
        about.add(aboutM);
        JMenuItem techM = MenuCreator.getSystemInfoItem();
        about.add(techM);
        JMenuItem memM = MenuCreator.getMemoryMonitorItem();
        about.add(memM);
        menu.add(Box.createGlue());
        menu.add(about);
        return menu;
    }

    private static JMenuItem getMemoryMonitorItem() {
        ImageIcon helpIcon = MenuCreator.createImageIcon("/icons/help.png");
        JMenuItem aboutM = null;
        aboutM = helpIcon == null ? new JMenuItem("Memory Monitor") : new JMenuItem("Memory Monitor", helpIcon);
        aboutM.setMnemonic(77);
        aboutM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCreator.showMemoryMonitor();
            }
        });
        return aboutM;
    }

    protected static void showMemoryMonitor() {
        final MemoryMonitor demo = new MemoryMonitor();
        JFrame f = new JFrame("MemoryMonitor");
        f.setDefaultCloseOperation(2);
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                demo.surf.start();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                demo.surf.stop();
            }
        };
        f.addWindowListener(l);
        Box vBox = Box.createVerticalBox();
        vBox.add(demo);
        Box b = Box.createHorizontalBox();
        JButton b1 = new JButton("Run Garbage Collector");
        b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        b.add(b1);
        b.add(Box.createGlue());
        vBox.add(b);
        f.getContentPane().add("Center", vBox);
        f.pack();
        f.setSize(new Dimension(200, 200));
        f.setVisible(true);
        demo.surf.start();
    }

    private static JMenuItem getConfigMenuItem() {
        ImageIcon configIcon = MenuCreator.createImageIcon("/icons/configure.png");
        JMenuItem configI = configIcon == null ? new JMenuItem("Settings") : new JMenuItem("Settings", configIcon);
        configI.setMnemonic(83);
        configI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals("Settings")) {
                    ConfigPDBInstallPanel.showDialog();
                }
            }
        });
        return configI;
    }

    public static class DotPlotListener
    implements ActionListener {
        private final AFPChain afpChain;

        public DotPlotListener(AFPChain afpChain) {
            this.afpChain = afpChain;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String title = String.format("%s vs. %s", this.afpChain.getName1(), this.afpChain.getName2());
            JFrame frame = new JFrame(title);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JFrame f = (JFrame)e.getSource();
                    f.setVisible(false);
                    f.dispose();
                }
            });
            DotPlotPanel dotplot = new DotPlotPanel(this.afpChain);
            frame.getContentPane().add(dotplot);
            frame.pack();
            frame.setVisible(true);
        }
    }
}

