/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.gui.AlignmentTextPanel;
import org.biojava.nbio.structure.align.gui.MenuCreator;
import org.biojava.nbio.structure.align.gui.aligpanel.MultipleAligPanel;
import org.biojava.nbio.structure.align.gui.aligpanel.MultipleStatusDisplay;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.JmolTools;
import org.biojava.nbio.structure.align.gui.jmol.MultipleAlignmentJmol;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.ReferenceSuperimposer;
import org.jcolorbrewer.ColorBrewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleAlignmentDisplay {
    private static final Logger logger = LoggerFactory.getLogger(MultipleAlignmentDisplay.class);

    public static final List<String> getPDBresnum(int structNum, MultipleAlignment multAln, Atom[] ca) {
        ArrayList<String> lst = new ArrayList<String>();
        for (Block block : multAln.getBlocks()) {
            for (int i = 0; i < block.length(); ++i) {
                Integer pos = (Integer)((List)block.getAlignRes().get(structNum)).get(i);
                if (pos == null || pos >= ca.length) continue;
                String pdbInfo = JmolTools.getPdbInfo(ca[pos]);
                lst.add(pdbInfo);
            }
        }
        return lst;
    }

    public static void showMultipleAligmentPanel(MultipleAlignment multAln, AbstractAlignmentJmol jmol, ColorBrewer colorPattelete) throws StructureException {
        MultipleAligPanel me = new MultipleAligPanel(multAln, jmol);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.setTitle(jmol.getTitle());
        me.setPreferredSize(new Dimension(me.getCoordManager().getPreferredWidth(), me.getCoordManager().getPreferredHeight()));
        JMenuBar menu = MenuCreator.getAlignmentPanelMenu(frame, me, null);
        frame.setJMenuBar(menu);
        JScrollPane scroll = new JScrollPane(me);
        scroll.setAutoscrolls(true);
        MultipleStatusDisplay status = new MultipleStatusDisplay(me);
        me.addAlignmentPositionListener(status);
        Box vBox = Box.createVerticalBox();
        vBox.add(scroll);
        vBox.add(status);
        frame.getContentPane().add(vBox);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(me);
        frame.addWindowListener(status);
    }

    public static void showAlignmentImage(MultipleAlignment multAln, String result) {
        JFrame frame = new JFrame();
        String title = multAln.getEnsemble().getAlgorithmName() + " V." + multAln.getEnsemble().getVersion();
        frame.setTitle(title);
        frame.setDefaultCloseOperation(2);
        AlignmentTextPanel txtPanel = new AlignmentTextPanel();
        txtPanel.setText(result);
        JMenuBar menu = MenuCreator.getAlignmentTextMenu(frame, txtPanel, null);
        frame.setJMenuBar(menu);
        JScrollPane js = new JScrollPane();
        js.getViewport().add(txtPanel);
        js.getViewport().setBorder(null);
        frame.getContentPane().add(js);
        frame.pack();
        frame.setVisible(true);
    }

    public static MultipleAlignmentJmol display(MultipleAlignment multAln) throws StructureException {
        int size = multAln.size();
        List atomArrays = multAln.getEnsemble().getAtomArrays();
        for (int i = 0; i < size; ++i) {
            if (((Atom[])atomArrays.get(i)).length >= 1) continue;
            throw new StructureException("Length of atoms arrays is too short! " + ((Atom[])atomArrays.get(i)).length);
        }
        ArrayList<Atom[]> rotatedAtoms = new ArrayList<Atom[]>();
        List transformations = multAln.getTransformations();
        if (multAln.getBlockSets().size() > 1) {
            transformations = ((BlockSet)multAln.getBlockSets().get(0)).getTransformations();
        }
        if (transformations == null) {
            logger.error("Alignment Transformations are not calculated. Superimposing to first structure as reference.");
            multAln = multAln.clone();
            ReferenceSuperimposer imposer = new ReferenceSuperimposer();
            imposer.superimpose(multAln);
            transformations = multAln.getTransformations();
            if (multAln.getBlockSets().size() > 1) {
                transformations = ((BlockSet)multAln.getBlockSets().get(0)).getTransformations();
            }
            assert (transformations != null);
        }
        for (int i = 0; i < size; ++i) {
            Structure displayS = ((Atom[])atomArrays.get(i))[0].getGroup().getChain().getParent().clone();
            Atom[] rotCA = StructureTools.getRepresentativeAtomArray((Structure)displayS);
            Calc.transform((Structure)rotCA[0].getGroup().getChain().getParent(), (Matrix4d)((Matrix4d)transformations.get(i)));
            rotatedAtoms.add(rotCA);
        }
        MultipleAlignmentJmol jmol = new MultipleAlignmentJmol(multAln, rotatedAtoms);
        jmol.setTitle(jmol.getStructure().getPDBHeader().getTitle());
        return jmol;
    }
}

