/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.align.gui.DisplayAFP;
import org.biojava.nbio.structure.align.gui.StructureAlignmentDisplay;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.WebStartMain;
import org.biojava.nbio.structure.align.xml.AFPChainXMLParser;

public class MyAlignmentLoadListener
implements ActionListener {
    AbstractAlignmentJmol jmol;

    public MyAlignmentLoadListener(AbstractAlignmentJmol jmol) {
        this.jmol = jmol;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                String str;
                InputStreamProvider ip = new InputStreamProvider();
                InputStream stream = ip.getInputStream(file);
                BufferedReader in = new BufferedReader(new InputStreamReader(stream));
                StringBuffer xml = new StringBuffer();
                while ((str = in.readLine()) != null) {
                    xml.append(str);
                }
                in.close();
                AFPChain[] afps = AFPChainXMLParser.parseMultiXML((String)xml.toString());
                AFPChain afpChain = afps[0];
                UserConfiguration config = WebStartMain.getWebStartConfig();
                AtomCache cache = new AtomCache(config.getPdbFilePath(), config.getCacheFilePath());
                Atom[] ca1 = cache.getAtoms(afpChain.getName1());
                Atom[] ca2 = cache.getAtoms(afpChain.getName2());
                AFPChainXMLParser.rebuildAFPChain((AFPChain)afpChain, (Atom[])ca1, (Atom[])ca2);
                StructureAlignmentJmol jmol = StructureAlignmentDisplay.display(afpChain, ca1, ca2);
                DisplayAFP.showAlignmentPanel(afpChain, ca1, ca2, jmol);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Could not load alignment file. Exception: " + e.getMessage());
            }
        }
    }
}

