/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.WebStartMain;
import org.biojava.nbio.structure.align.xml.AFPChainXMLConverter;

public class MySaveFileListener
implements ActionListener {
    AFPChain afpChain;
    private boolean printFatCat;

    public MySaveFileListener(AFPChain afpChain) {
        this.afpChain = afpChain;
        this.printFatCat = false;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.afpChain == null) {
            JOptionPane.showMessageDialog(null, "Could not save alignment, no alignment being displayed.");
            return;
        }
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(null);
        if (returnVal != 0) {
            System.err.println("User canceled file save.");
            return;
        }
        File selFile = fc.getSelectedFile();
        if (selFile == null) {
            return;
        }
        System.out.println("Saving alignment to file: " + selFile.getName());
        try {
            UserConfiguration config = WebStartMain.getWebStartConfig();
            AtomCache cache = new AtomCache(config);
            Atom[] ca1 = cache.getAtoms(this.afpChain.getName1());
            Atom[] ca2 = cache.getAtoms(this.afpChain.getName2());
            String output = "";
            output = !this.printFatCat ? AFPChainXMLConverter.toXML((AFPChain)this.afpChain, (Atom[])ca1, (Atom[])ca2) : this.afpChain.toFatcat(ca1, ca2);
            BufferedWriter out = new BufferedWriter(new FileWriter(selFile));
            out.write(output);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not save file. Exception: " + e.getMessage());
        }
    }

    public void setFatCatOutput(boolean b) {
        this.printFatCat = b;
    }
}

