/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.WebStartMain;
import org.biojava.nbio.structure.gui.util.StructurePairSelector;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.MMCIFFileReader;
import org.biojava.nbio.structure.io.PDBFileReader;

public class SelectPDBPanel
extends JPanel
implements StructurePairSelector {
    boolean debug = true;
    JTextField f1;
    JTextField f2;
    JTextField c1;
    JTextField c2;
    JTextField r1;
    JTextField r2;
    UserConfiguration config;
    JTabbedPane configPane;
    private static final long serialVersionUID = 4002475313717172193L;

    public SelectPDBPanel() {
        this(true);
    }

    public SelectPDBPanel(boolean show2PDBs) {
        Box vBox = Box.createVerticalBox();
        JLabel help = new JLabel("Optional: specify chain ID or range.");
        Box hBox1 = Box.createHorizontalBox();
        hBox1.add(Box.createGlue());
        hBox1.add(help);
        vBox.add(hBox1);
        int pdbfSize = 4;
        this.f1 = new JTextField(pdbfSize);
        this.c1 = new JTextField(1);
        this.r1 = new JTextField(5);
        Box p1 = this.getPDBFilePanel(1, this.f1, this.c1, this.r1);
        vBox.add(p1);
        this.f2 = new JTextField(pdbfSize);
        this.c2 = new JTextField(1);
        this.r2 = new JTextField(5);
        Box p2 = this.getPDBFilePanel(2, this.f2, this.c2, this.r2);
        if (show2PDBs) {
            vBox.add(p2);
        }
        this.add(vBox);
    }

    public String getName1() {
        String chainId = this.c1.getText().trim();
        String name = this.f1.getText().trim();
        if (!chainId.equals("")) {
            name = name + "." + chainId;
        }
        return name;
    }

    public String getName2() {
        String chainId = this.c2.getText().trim();
        String name = this.f2.getText().trim();
        if (!chainId.equals("")) {
            name = name + "." + chainId;
        }
        return name;
    }

    @Override
    public Structure getStructure1() throws StructureException {
        return this.fromPDB(this.f1, this.c1, this.r1);
    }

    @Override
    public Structure getStructure2() throws StructureException {
        return this.fromPDB(this.f2, this.c2, this.r2);
    }

    private Structure fromPDB(JTextField f, JTextField c, JTextField r) throws StructureException {
        Structure structure;
        PDBFileReader re;
        String pdb = f.getText().trim();
        UserConfiguration config = WebStartMain.getWebStartConfig();
        if (pdb.length() < 4) {
            f.setText("!!!");
            return null;
        }
        String chain = c.getText().trim();
        if (this.debug) {
            System.out.println("file :" + pdb + " " + chain);
        }
        String range = r.getText().trim();
        String fileFormat = config.getFileFormat();
        PDBFileReader reader = null;
        if (fileFormat.equals("PDB")) {
            re = new PDBFileReader(config.getPdbFilePath());
            re.setFetchBehavior(config.getFetchBehavior());
            reader = re;
        } else if (fileFormat.equals("mmCif")) {
            re = new MMCIFFileReader(config.getPdbFilePath());
            re.setFetchBehavior(config.getFetchBehavior());
            reader = re;
        } else {
            throw new StructureException("Unkown file format " + fileFormat);
        }
        FileParsingParameters params = new FileParsingParameters();
        params.setAlignSeqRes(false);
        reader.setFileParsingParameters(params);
        try {
            structure = reader.getStructureById(pdb);
        }
        catch (IOException e) {
            throw new StructureException("Could not read structure " + pdb, (Throwable)e);
        }
        if (range != null && !range.equals("")) {
            if (structure.getName() == null || structure.getName().equals("")) {
                structure.setName(pdb);
            }
            Structure s = StructureTools.getSubRanges((Structure)structure, (String)range);
            return s;
        }
        Structure s = StructureTools.getReducedStructure((Structure)structure, (String)chain);
        if (s.getName() == null || s.getName().equals("")) {
            s.setName(pdb + "." + chain);
        }
        return s;
    }

    private Box getPDBFilePanel(int pos, JTextField f, JTextField c, JTextField r) {
        JLabel l01 = new JLabel("PDB code ");
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createGlue());
        hBox.add(l01);
        JLabel l11 = new JLabel(pos + ":");
        f.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        f.setToolTipText("Provide 4-character PDB code here. Example: 4hhb");
        hBox.add(l11);
        hBox.add(Box.createVerticalGlue());
        hBox.add((Component)f, "Center");
        hBox.add(Box.createGlue());
        JLabel l21 = new JLabel("Chain" + pos + ":");
        hBox.add(l21);
        c.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        hBox.add((Component)c, "Center");
        String msg1 = "Both chainID and range specification are optional. If both are provided, range has preference.";
        l21.setToolTipText(msg1);
        c.setToolTipText(msg1);
        JLabel rangeL = new JLabel(" Range " + pos + ":");
        hBox.add(Box.createGlue());
        hBox.add(rangeL);
        r.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        String msg = "Syntax example: A:407-495,A:582-686";
        rangeL.setToolTipText(msg);
        r.setToolTipText(msg);
        hBox.add((Component)r, "Center");
        return hBox;
    }
}

