/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.AFPTwister;
import org.biojava.nbio.structure.align.fatcat.FatCatFlexible;
import org.biojava.nbio.structure.align.fatcat.FatCatRigid;
import org.biojava.nbio.structure.align.gui.DisplayAFP;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.jama.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureAlignmentDisplay {
    private static final Logger logger = LoggerFactory.getLogger(StructureAlignmentDisplay.class);

    public static StructureAlignmentJmol display(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        if (ca1.length < 1 || ca2.length < 1) {
            throw new StructureException("length of atoms arrays is too short! " + ca1.length + "," + ca2.length);
        }
        Group[] twistedGroups = StructureAlignmentDisplay.prepareGroupsForDisplay(afpChain, ca1, ca2);
        List hetatms = StructureTools.getUnalignedGroups((Atom[])ca1);
        List hetatms2 = StructureTools.getUnalignedGroups((Atom[])ca2);
        return DisplayAFP.display(afpChain, twistedGroups, ca1, ca2, hetatms, hetatms2);
    }

    public static Group[] prepareGroupsForDisplay(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        if (afpChain.getBlockRotationMatrix().length == 0) {
            System.err.println("No rotation matrix found to rotate 2nd structure!");
            afpChain.setBlockRotationMatrix(new Matrix[]{Matrix.identity((int)3, (int)3)});
            afpChain.setBlockShiftVector(new Atom[]{new AtomImpl()});
        }
        Group[] twistedGroups = new Group[ca2.length];
        int i = -1;
        List hetatms2 = StructureTools.getUnalignedGroups((Atom[])ca2);
        if (afpChain.getAlgorithmName().equals(FatCatRigid.algorithmName) || afpChain.getAlgorithmName().equals(FatCatFlexible.algorithmName)) {
            for (Atom a : ca2) {
                twistedGroups[++i] = a.getGroup();
            }
            twistedGroups = AFPTwister.twistOptimized((AFPChain)afpChain, (Atom[])ca1, (Atom[])ca2);
        } else {
            Matrix m = afpChain.getBlockRotationMatrix()[0];
            Atom shift = afpChain.getBlockShiftVector()[0];
            StructureAlignmentDisplay.shiftCA2(afpChain, ca2, m, shift, twistedGroups);
        }
        if (afpChain.getBlockNum() > 0 && hetatms2.size() > 0 && afpChain.getBlockRotationMatrix().length > 0) {
            Matrix m1 = afpChain.getBlockRotationMatrix()[0];
            Atom vector1 = afpChain.getBlockShiftVector()[0];
            for (Group g : hetatms2) {
                Calc.rotate((Group)g, (Matrix)m1);
                Calc.shift((Group)g, (Atom)vector1);
            }
        }
        return twistedGroups;
    }

    public static void shiftCA2(AFPChain afpChain, Atom[] ca2, Matrix m, Atom shift, Group[] twistedGroups) {
        int i = -1;
        for (Atom a : ca2) {
            ++i;
            Group g = a.getGroup();
            Calc.rotate((Group)g, (Matrix)m);
            Calc.shift((Group)g, (Atom)shift);
            if (g.hasAltLoc()) {
                for (Group alt : g.getAltLocs()) {
                    for (Atom alta : alt.getAtoms()) {
                        if (g.getAtoms().contains(alta)) continue;
                        Calc.rotate((Atom)alta, (Matrix)m);
                        Calc.shift((Atom)alta, (Atom)shift);
                    }
                }
            }
            twistedGroups[i] = g;
        }
    }
}

