/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureIO;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.quaternary.BioAssemblyTools;

public class StructureLoaderThread
extends SwingWorker<String, Object> {
    String name;
    boolean showBiolAssembly;
    UserConfiguration config;
    static JFrame progressFrame = null;

    StructureLoaderThread(UserConfiguration config, String name, boolean showBiolAssembly) {
        this.name = name;
        this.showBiolAssembly = showBiolAssembly;
        this.config = config;
    }

    @Override
    protected String doInBackground() {
        System.out.println("loading " + this.name);
        AtomCache cache = new AtomCache(this.config.getPdbFilePath(), this.config.getCacheFilePath());
        Structure s = null;
        try {
            if (this.showBiolAssembly) {
                s = StructureIO.getBiologicalAssembly((String)this.name);
                int atomCount = StructureTools.getNrAtoms((Structure)s);
                if (atomCount > 200000) {
                    System.err.println("Structure very large. Reducing display to C alpha atoms only");
                    s = BioAssemblyTools.getReducedCAStructure((Structure)s);
                }
            } else {
                s = cache.getStructure(this.name);
            }
            System.out.println("done loading structure...");
            StructureAlignmentJmol jmol = new StructureAlignmentJmol();
            jmol.setStructure(s);
            jmol.evalString("set antialiasDisplay on; select all;spacefill off; wireframe off; backbone off; cartoon;color cartoon chain; select ligand;wireframe 0.16;spacefill 0.5; select all; color cartoon structure;");
            jmol.evalString("save STATE state_1");
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error while loading " + this.name + ":" + e.getMessage());
            s = new StructureImpl();
        }
        this.hideProgressBar();
        return "Done.";
    }

    public static void showProgressBar() {
        if (progressFrame == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFrame frame = new JFrame("Loading ...");
                    JProgressBar progressBar = new JProgressBar();
                    progressBar.setIndeterminate(true);
                    JPanel contentPane = new JPanel();
                    contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    contentPane.setLayout(new BorderLayout());
                    contentPane.add((Component)new JLabel("Loading ..."), "North");
                    contentPane.add((Component)progressBar, "Center");
                    frame.setContentPane(contentPane);
                    frame.pack();
                    frame.setLocationRelativeTo(null);
                    progressFrame = frame;
                    frame.setVisible(true);
                }
            });
        }
    }

    private void hideProgressBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (progressFrame != null) {
                    progressFrame.dispose();
                    progressFrame = null;
                }
            }
        });
    }
}

