/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.aligpanel;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.gui.JPrintPanel;
import org.biojava.nbio.structure.align.gui.MultipleAlignmentDisplay;
import org.biojava.nbio.structure.align.gui.aligpanel.MultipleAligPanelMouseMotionListener;
import org.biojava.nbio.structure.align.gui.aligpanel.MultipleAlignmentCoordManager;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.JmolTools;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsembleImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentTools;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentWriter;
import org.biojava.nbio.structure.align.util.AFPAlignmentDisplay;
import org.biojava.nbio.structure.gui.events.AlignmentPositionListener;
import org.biojava.nbio.structure.gui.util.AlignedPosition;

public class MultipleAligPanel
extends JPrintPanel
implements AlignmentPositionListener,
WindowListener {
    private static final long serialVersionUID = -6892229111166263764L;
    private MultipleAlignment multAln;
    private List<String> alnSeq;
    private List<Integer> mapSeqToStruct;
    int size;
    int length;
    private Font seqFont;
    private Font eqFont;
    private AbstractAlignmentJmol jmol;
    private MultipleAligPanelMouseMotionListener mouseMoLi;
    private MultipleAlignmentCoordManager coordManager;
    private BitSet selection;
    private boolean selectionLocked;
    private boolean colorBySimilarity = false;
    private boolean colorByAlignmentBlock = false;
    private static final Color COLOR_EQUAL = Color.decode("#6A93D4");
    private static final Color COLOR_SIMILAR = Color.decode("#D460CF");

    public MultipleAligPanel() {
        this.setBackground(Color.white);
        this.seqFont = new Font("SansSerif", 0, 12);
        this.eqFont = new Font("SansSerif", 1, 12);
        this.mouseMoLi = new MultipleAligPanelMouseMotionListener(this);
        this.addMouseMotionListener(this.mouseMoLi);
        this.addMouseListener(this.mouseMoLi);
        this.mouseMoLi.addAligPosListener(this);
        this.selection = new BitSet();
        this.multAln = null;
        this.alnSeq = null;
        this.mapSeqToStruct = null;
    }

    public MultipleAligPanel(AFPChain afpChain, Atom[] ca1, Atom[] ca2, AbstractAlignmentJmol jmol) throws StructureException {
        this();
        MultipleAlignmentEnsembleImpl ensemble = new MultipleAlignmentEnsembleImpl(afpChain, ca1, ca2);
        this.multAln = (MultipleAlignment)ensemble.getMultipleAlignments().get(0);
        this.mapSeqToStruct = new ArrayList<Integer>();
        this.alnSeq = MultipleAlignmentTools.getSequenceAlignment((MultipleAlignment)this.multAln, this.mapSeqToStruct);
        this.size = this.multAln.size();
        this.length = this.alnSeq.get(0).length();
        this.coordManager = new MultipleAlignmentCoordManager(this.size, this.length);
        this.jmol = jmol;
    }

    public MultipleAligPanel(MultipleAlignment multAln, AbstractAlignmentJmol jmol) {
        this();
        this.multAln = multAln;
        this.mapSeqToStruct = new ArrayList<Integer>();
        this.alnSeq = MultipleAlignmentTools.getSequenceAlignment((MultipleAlignment)this.multAln, this.mapSeqToStruct);
        this.size = multAln.size();
        this.length = this.alnSeq.get(0).length();
        this.coordManager = new MultipleAlignmentCoordManager(this.size, this.length);
        this.jmol = jmol;
    }

    public MultipleAlignmentCoordManager getCoordManager() {
        return this.coordManager;
    }

    public void addAlignmentPositionListener(AlignmentPositionListener li) {
        this.mouseMoLi.addAligPosListener(li);
    }

    public void destroy() {
        this.multAln = null;
        this.alnSeq = null;
        this.mouseMoLi.destroy();
        this.jmol = null;
        this.selection = null;
    }

    @Override
    public void paintComponent(Graphics g) {
        Point p1;
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int startpos = 0;
        int endpos = this.length;
        String summary = this.multAln.toString();
        g2D.drawString(summary, 20, this.coordManager.getSummaryPos());
        Color significantCol = Color.black;
        g2D.setPaint(significantCol);
        Rectangle sig = new Rectangle(10, 10, 10, 10);
        g2D.fill(sig);
        for (int i = startpos; i < endpos; ++i) {
            boolean isGapped = false;
            g2D.setFont(this.seqFont);
            if (this.mapSeqToStruct.get(i) != -1) {
                g2D.setFont(this.eqFont);
            } else {
                isGapped = true;
            }
            ArrayList<Point> points = new ArrayList<Point>();
            for (int str = 0; str < this.size; ++str) {
                points.add(this.coordManager.getPanelPos(str, i));
            }
            p1 = (Point)points.get(0);
            Point p2 = (Point)points.get(points.size() - 1);
            for (int str = 0; str < this.size; ++str) {
                char c = this.alnSeq.get(str).charAt(i);
                Color bg = this.jmol.getColorPalette().getColorPalette(this.size)[str];
                if (!isGapped) {
                    if (this.colorBySimilarity) {
                        boolean equal = true;
                        boolean similar = true;
                        char c1 = '-';
                        for (int st = 0; st < this.size - 1; ++st) {
                            if (this.alnSeq.get(st).charAt(i) != '-') {
                                c1 = this.alnSeq.get(st).charAt(i);
                            }
                            char c2 = this.alnSeq.get(st + 1).charAt(i);
                            if (c1 == '-' || c2 == '-' || Character.isLowerCase(c1) || Character.isLowerCase(c2) || equal && c1 == c2) continue;
                            equal = false;
                            if (AFPAlignmentDisplay.aaScore((char)c1, (char)c2) > 0) continue;
                            similar = false;
                            break;
                        }
                        bg = equal ? COLOR_EQUAL : (similar ? COLOR_SIMILAR : Color.LIGHT_GRAY);
                    } else if (this.colorByAlignmentBlock) {
                        int blockNr = MultipleAlignmentTools.getBlockForSequencePosition((MultipleAlignment)this.multAln, this.mapSeqToStruct, (int)i);
                        bg = this.jmol.getColorPalette().getColorPalette(this.multAln.getBlocks().size())[blockNr];
                    }
                    if (this.isSelected(i)) {
                        bg = Color.YELLOW;
                    }
                    if (Character.isUpperCase(c) && c != '-') {
                        g2D.setPaint(bg);
                        Rectangle rec = new Rectangle(((Point)points.get((int)str)).x - 1, ((Point)points.get((int)str)).y - 11, p2.x - p1.x + 12, (p2.y - p1.y) / this.size);
                        g2D.fill(rec);
                    }
                }
                g2D.setColor(Color.black);
                g2D.drawString(c + "", ((Point)points.get((int)str)).x, ((Point)points.get((int)str)).y);
            }
        }
        int nrLines = (this.length - 1) / 70;
        for (int i = 0; i < nrLines + 1; ++i) {
            for (int str = 0; str < this.size; ++str) {
                int aligPos;
                p1 = this.coordManager.getLegendPosition(i, str);
                Atom a1 = null;
                for (aligPos = i * 70; a1 == null && aligPos < Math.min((i + 1) * 70 - 1, this.length); ++aligPos) {
                    a1 = MultipleAlignmentTools.getAtomForSequencePosition((MultipleAlignment)this.multAln, this.mapSeqToStruct, (int)str, (int)aligPos);
                }
                String label1 = JmolTools.getPdbInfo(a1, false);
                g2D.drawString(label1, p1.x, p1.y);
                Point p3 = this.coordManager.getEndLegendPosition(i, str);
                aligPos = i * 70 + 70 - 1;
                if (aligPos > this.length) {
                    aligPos = this.length - 1;
                }
                Atom a3 = null;
                while (a3 == null && aligPos > Math.max(i * 70, 0)) {
                    a3 = MultipleAlignmentTools.getAtomForSequencePosition((MultipleAlignment)this.multAln, this.mapSeqToStruct, (int)str, (int)aligPos);
                    --aligPos;
                }
                String label3 = JmolTools.getPdbInfo(a3, false);
                g2D.drawString(label3, p3.x, p3.y);
            }
        }
    }

    private boolean isSelected(int alignmentPosition) {
        return this.selection.get(alignmentPosition);
    }

    @Override
    public void mouseOverPosition(AlignedPosition p) {
        if (!this.selectionLocked) {
            this.selection.clear();
        }
        this.selection.set(p.getPos1());
        this.updateJmolDisplay();
        this.repaint();
    }

    private void updateJmolDisplay() {
        if (this.jmol == null) {
            return;
        }
        StringBuffer cmd = new StringBuffer("select ");
        int nrSelected = 0;
        for (int i = 0; i < this.length; ++i) {
            if (!this.selection.get(i)) continue;
            for (int str = 0; str < this.size; ++str) {
                Atom a = MultipleAlignmentTools.getAtomForSequencePosition((MultipleAlignment)this.multAln, this.mapSeqToStruct, (int)str, (int)i);
                if (a == null) continue;
                cmd.append(JmolTools.getPdbInfo(a));
                cmd.append("/" + (str + 1) + ", ");
            }
            ++nrSelected;
        }
        if (nrSelected == 0) {
            cmd.append(" none;");
        } else {
            cmd.append(" none; set display selected;");
        }
        this.jmol.evalString(cmd.toString());
    }

    @Override
    public void positionSelected(AlignedPosition p) {
        this.mouseOverPosition(p);
    }

    @Override
    public void rangeSelected(AlignedPosition start, AlignedPosition end) {
        if (!this.selectionLocked) {
            this.selection.clear();
        }
        this.selection.set(start.getPos1(), end.getPos1() + 1);
        this.updateJmolDisplay();
        this.repaint();
    }

    @Override
    public void selectionLocked() {
        this.selectionLocked = true;
    }

    @Override
    public void selectionUnlocked() {
        this.selectionLocked = false;
        this.selection.clear();
        this.repaint();
    }

    @Override
    public void toggleSelection(AlignedPosition p) {
        this.selection.flip(p.getPos1());
        this.updateJmolDisplay();
        this.repaint();
    }

    public void setStructureAlignmentJmol(AbstractAlignmentJmol jmol) {
        this.jmol = jmol;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.destroy();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Print")) {
            super.actionPerformed(e);
        } else if (cmd.equals("View FASTA Alignment")) {
            String result = MultipleAlignmentWriter.toFASTA((MultipleAlignment)this.multAln);
            MultipleAlignmentDisplay.showAlignmentImage(this.multAln, result);
        } else if (cmd.equals("View Aligned Pairs")) {
            String result = MultipleAlignmentWriter.toAlignedResidues((MultipleAlignment)this.multAln);
            MultipleAlignmentDisplay.showAlignmentImage(this.multAln, result);
        } else if (cmd.equals("View as FATCAT result")) {
            String result = MultipleAlignmentWriter.toFatCat((MultipleAlignment)this.multAln);
            MultipleAlignmentDisplay.showAlignmentImage(this.multAln, result);
        } else if (cmd.equals("Select Equivalent Positions")) {
            this.selectEQR();
        } else if (cmd.equals("Color By Similarity")) {
            this.colorBySimilarity(true);
        } else if (cmd.equals("Color By EQR")) {
            this.colorBySimilarity(false);
        } else if (cmd.equals("Color By Alignment Block")) {
            this.colorByAlignmentBlock();
        } else {
            System.err.println("Unknown command:" + cmd);
        }
    }

    private void selectEQR() {
        this.selection.clear();
        for (int pos = 0; pos < this.length; ++pos) {
            if (this.mapSeqToStruct.get(pos) == -1) continue;
            this.selection.flip(pos);
        }
        this.mouseMoLi.triggerSelectionLocked(true);
        this.updateJmolDisplay();
        this.repaint();
    }

    private void colorByAlignmentBlock() {
        this.colorByAlignmentBlock = true;
        this.colorBySimilarity = false;
        this.repaint();
    }

    private void colorBySimilarity(boolean flag) {
        this.colorBySimilarity = flag;
        this.colorByAlignmentBlock = false;
        this.repaint();
    }

    public List<Atom[]> getAtomArrays() {
        return this.multAln.getEnsemble().getAtomArrays();
    }

    public MultipleAlignment getMultipleAlignment() {
        return this.multAln;
    }

    public List<String> getAlnSequences() {
        return this.alnSeq;
    }

    public List<Integer> getMapSeqToStruct() {
        return this.mapSeqToStruct;
    }
}

