/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.aligpanel;

import java.awt.Point;

public class MultipleAlignmentCoordManager {
    private int alignmentLength;
    private int alignmentSize;
    public static final int DEFAULT_RIGHT_SPACER = 10;
    public static final int DEFAULT_LINE_LENGTH = 70;
    public final int DEFAULT_Y_STEP;
    public static final int DEFAULT_CHAR_SIZE = 12;
    public static final int DEFAULT_LINE_SEPARATION = 20;
    public static final int DEFAULT_X_SPACE = 20;
    public static final int DEFAULT_Y_SPACE = 40;
    public static final int SUMMARY_POS = 20;
    private static final int DEFAULT_LEGEND_SIZE = 50;

    public MultipleAlignmentCoordManager(int size, int length) {
        this.alignmentLength = length;
        this.alignmentSize = size;
        this.DEFAULT_Y_STEP = 30 * size;
    }

    public int getSummaryPos() {
        return 20;
    }

    public int getPreferredWidth() {
        return this.alignmentSize * 20 + 840 + 50 + 10 + 50;
    }

    public int getPreferredHeight() {
        return this.alignmentSize * 40 + this.alignmentLength / 70 * this.DEFAULT_Y_STEP + 20;
    }

    public int getSeqPos(int aligSeq, Point p) {
        int x = p.x - 20 - 50;
        int y = p.y - 40;
        int lineNr = (y -= 20 * aligSeq - 12) / this.DEFAULT_Y_STEP;
        int linePos = x / 12;
        return lineNr * 70 + linePos;
    }

    public Point getPanelPos(int aligSeq, int i) {
        Point p = new Point();
        int lineNr = i / 70;
        int linePos = i % 70;
        int x = linePos * 12 + 20 + 50;
        int y = lineNr * this.DEFAULT_Y_STEP + 40;
        p.setLocation(x, y += 20 * aligSeq);
        return p;
    }

    public int getAligSeq(Point point) {
        for (int pos = 0; pos < this.alignmentSize; ++pos) {
            int i = this.getSeqPos(pos, point);
            Point t = this.getPanelPos(pos, i);
            if (Math.abs(t.x - point.x) > 12 || Math.abs(t.y - point.y) >= 12) continue;
            return pos;
        }
        return -1;
    }

    public Point getLegendPosition(int lineNr, int chainNr) {
        int x = 20;
        int y = lineNr * this.DEFAULT_Y_STEP + 40;
        Point p = new Point(x, y += chainNr * 20);
        return p;
    }

    public Point getEndLegendPosition(int lineNr, int chainNr) {
        int x = 920;
        int y = lineNr * this.DEFAULT_Y_STEP + 40;
        Point p = new Point(x, y += chainNr * 20);
        return p;
    }
}

