/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.jmol;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.gui.AlignmentGui;
import org.biojava.nbio.structure.align.gui.DisplayAFP;
import org.biojava.nbio.structure.align.gui.MenuCreator;
import org.biojava.nbio.structure.align.gui.MultipleAlignmentDisplay;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.JmolPanel;
import org.biojava.nbio.structure.align.gui.jmol.JmolTools;
import org.biojava.nbio.structure.align.gui.jmol.MyJmolStatusListener;
import org.biojava.nbio.structure.align.gui.jmol.RasmolCommandListener;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentWriter;
import org.biojava.nbio.structure.align.webstart.AligUIManager;
import org.biojava.nbio.structure.jama.Matrix;
import org.jcolorbrewer.ColorBrewer;

public class MultipleAlignmentJmol
extends AbstractAlignmentJmol {
    private MultipleAlignment multAln;
    private List<Atom[]> atomArrays;
    private boolean colorByBlocks = false;
    private List<JCheckBox> selectedStructures;

    public MultipleAlignmentJmol() {
        this(null, null);
    }

    public MultipleAlignmentJmol(MultipleAlignment msa, List<Atom[]> rotatedAtoms) {
        AligUIManager.setLookAndFeel();
        ++nrOpenWindows;
        this.jmolPanel = new JmolPanel();
        this.frame = new JFrame();
        JMenuBar menu = MenuCreator.initJmolMenu(this.frame, this, null);
        this.frame.setJMenuBar(menu);
        this.multAln = msa;
        this.atomArrays = rotatedAtoms;
        this.selectedStructures = new ArrayList<JCheckBox>();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MultipleAlignmentJmol.this.destroy();
                if (--AbstractAlignmentJmol.nrOpenWindows > 0) {
                    MultipleAlignmentJmol.this.frame.dispose();
                } else {
                    AlignmentGui gui = AlignmentGui.getInstanceNoVisibilityChange();
                    if (gui.isVisible()) {
                        MultipleAlignmentJmol.this.frame.dispose();
                        gui.requestFocus();
                    } else {
                        System.exit(0);
                    }
                }
            }
        });
        Container contentPane = this.frame.getContentPane();
        Box vBox = Box.createVerticalBox();
        this.jmolPanel.addMouseMotionListener(this);
        this.jmolPanel.addMouseListener(this);
        this.jmolPanel.setPreferredSize(new Dimension(500, 500));
        vBox.add(this.jmolPanel);
        JTextField field = new JTextField();
        field.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        field.setText("enter Jmol scripting command...");
        RasmolCommandListener listener = new RasmolCommandListener(this.jmolPanel, field);
        field.addActionListener(listener);
        field.addMouseListener(listener);
        field.addKeyListener(listener);
        vBox.add(field);
        Box hBox0 = Box.createHorizontalBox();
        hBox0.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        JButton show = new JButton("Show Only: ");
        show.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleAlignmentJmol.this.jmolPanel.evalString("save selection;");
                String cmd = MultipleAlignmentJmol.this.getJmolString();
                cmd = cmd + "; restrict ";
                for (int st = 0; st < MultipleAlignmentJmol.this.multAln.size(); ++st) {
                    if (!((JCheckBox)MultipleAlignmentJmol.this.selectedStructures.get(st)).isSelected()) continue;
                    cmd = cmd + "*/" + (st + 1) + ", ";
                }
                cmd = cmd + "none;";
                MultipleAlignmentJmol.this.jmolPanel.executeCmd(cmd + " restore selection;");
            }
        });
        hBox0.add(show);
        hBox0.add(Box.createGlue());
        for (int str = 0; str < this.multAln.size(); ++str) {
            JCheckBox structureSelection = new JCheckBox((String)this.multAln.getEnsemble().getStructureNames().get(str));
            hBox0.add(structureSelection);
            hBox0.add(Box.createGlue());
            structureSelection.setSelected(true);
            this.selectedStructures.add(structureSelection);
        }
        vBox.add(hBox0);
        Box hBox1 = Box.createHorizontalBox();
        hBox1.add(Box.createGlue());
        String[] styles = new String[]{"Cartoon", "Backbone", "CPK", "Ball and Stick", "Ligands", "Ligands and Pocket"};
        JComboBox<String> style = new JComboBox<String>(styles);
        hBox1.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        hBox1.add(new JLabel("Style"));
        hBox1.add(style);
        vBox.add(hBox1);
        contentPane.add(vBox);
        style.addActionListener(this.jmolPanel);
        String[] colorModes = new String[]{"Secondary Structure", "By Chain", "Rainbow", "By Element", "By Amino Acid", "Hydrophobicity", "Suggest Domains", "Show SCOP Domains"};
        JComboBox<String> jcolors = new JComboBox<String>(colorModes);
        jcolors.addActionListener(this.jmolPanel);
        hBox1.add(Box.createGlue());
        hBox1.add(new JLabel("Color"));
        hBox1.add(jcolors);
        String[] cPalette = new String[]{"Spectral", "Set1", "Set2", "Pastel"};
        JComboBox<String> palette = new JComboBox<String>(cPalette);
        palette.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                String value = source.getSelectedItem().toString();
                MultipleAlignmentJmol.this.evalString("save selection; select *; color grey; select ligand; color CPK;");
                if (value == "Set1") {
                    MultipleAlignmentJmol.this.colorPalette = ColorBrewer.Set1;
                } else if (value == "Set2") {
                    MultipleAlignmentJmol.this.colorPalette = ColorBrewer.Set2;
                } else if (value == "Spectral") {
                    MultipleAlignmentJmol.this.colorPalette = ColorBrewer.Spectral;
                } else if (value == "Pastel") {
                    MultipleAlignmentJmol.this.colorPalette = ColorBrewer.Pastel1;
                }
                String script = "";
                script = MultipleAlignmentJmol.this.getJmolString();
                MultipleAlignmentJmol.this.evalString(script + "; restore selection; ");
            }
        });
        hBox1.add(Box.createGlue());
        hBox1.add(new JLabel("Palette"));
        hBox1.add(palette);
        Box hBox2 = Box.createHorizontalBox();
        hBox2.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        JButton resetDisplay = new JButton("Reset Display");
        resetDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("reset!!");
                MultipleAlignmentJmol.this.jmolPanel.executeCmd("restore STATE state_1");
            }
        });
        hBox2.add(resetDisplay);
        hBox2.add(Box.createGlue());
        JCheckBox toggleSelection = new JCheckBox("Show Selection");
        toggleSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean showSelection;
                boolean bl = showSelection = e.getStateChange() == 1;
                if (showSelection) {
                    MultipleAlignmentJmol.this.jmolPanel.executeCmd("set display selected");
                } else {
                    MultipleAlignmentJmol.this.jmolPanel.executeCmd("set display off");
                }
            }
        });
        hBox2.add(toggleSelection);
        hBox2.add(Box.createGlue());
        JCheckBox blockColor = new JCheckBox("Color By Block");
        blockColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MultipleAlignmentJmol.this.colorByBlocks = e.getStateChange() == 1;
                MultipleAlignmentJmol.this.evalString("save selection; " + MultipleAlignmentJmol.this.getJmolString() + "; restore selection;");
            }
        });
        hBox2.add(blockColor);
        hBox2.add(Box.createGlue());
        vBox.add(hBox2);
        Box hBox = Box.createHorizontalBox();
        this.status = new JTextField();
        this.status.setBackground(Color.white);
        this.status.setEditable(false);
        this.status.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.status.setPreferredSize(new Dimension(250, 30));
        this.status.setMinimumSize(new Dimension(250, 30));
        hBox.add(this.status);
        this.text = new JTextField();
        this.text.setBackground(Color.white);
        this.text.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.text.setPreferredSize(new Dimension(250, 30));
        this.text.setMinimumSize(new Dimension(250, 30));
        this.text.setText("Display of Atom info");
        this.text.setEditable(false);
        hBox.add(this.text);
        vBox.add(hBox);
        contentPane.add(vBox);
        MyJmolStatusListener li = (MyJmolStatusListener)this.jmolPanel.getStatusListener();
        li.setTextField(this.status);
        this.frame.pack();
        this.frame.setVisible(true);
        this.initCoords();
        this.resetDisplay();
    }

    @Override
    protected void initCoords() {
        try {
            if (this.multAln == null) {
                if (this.structure != null) {
                    this.setStructure(this.structure);
                } else {
                    return;
                }
            }
            Structure artificial = DisplayAFP.getAlignedStructure(this.atomArrays);
            PDBHeader header = new PDBHeader();
            String title = this.multAln.getEnsemble().getAlgorithmName() + " V." + this.multAln.getEnsemble().getVersion() + " : ";
            for (String name : this.multAln.getEnsemble().getStructureNames()) {
                title = title + name + " ";
            }
            System.out.println(title);
            header.setTitle(title);
            artificial.setPDBHeader(header);
            this.setStructure(artificial);
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.multAln = null;
        this.atomArrays = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("View Text Only")) {
            if (this.multAln == null) {
                System.err.println("Currently not viewing an alignment!");
                return;
            }
            System.out.println("Option currently not available for Multiple Alignments");
        } else if (cmd.equals("View Aligned Pairs")) {
            if (this.multAln == null) {
                System.err.println("Currently not viewing an alignment!");
                return;
            }
            String result = MultipleAlignmentWriter.toAlignedResidues((MultipleAlignment)this.multAln);
            MultipleAlignmentDisplay.showAlignmentImage(this.multAln, result);
        } else if (cmd.equals("Alignment Panel")) {
            if (this.multAln == null) {
                System.err.println("Currently not viewing an alignment!");
                return;
            }
            try {
                MultipleAlignmentDisplay.showMultipleAligmentPanel(this.multAln, this, this.colorPalette);
            }
            catch (StructureException e1) {
                e1.printStackTrace();
            }
        } else if (cmd.equals("View as FATCAT result")) {
            if (this.multAln == null) {
                System.err.println("Currently not viewing an alignment!");
                return;
            }
            String result = MultipleAlignmentWriter.toFatCat((MultipleAlignment)this.multAln);
            result = result + "\n" + MultipleAlignmentWriter.toTransformMatrices((MultipleAlignment)this.multAln);
            MultipleAlignmentDisplay.showAlignmentImage(this.multAln, result);
        }
    }

    private String getJmolString() {
        if (this.colorByBlocks) {
            return this.getMultiBlockJmolString();
        }
        Color[] colors = this.colorPalette.getColorPalette(this.multAln.size());
        StringBuffer j = new StringBuffer();
        j.append(DEFAULT_SCRIPT);
        StringBuffer sel = new StringBuffer();
        sel.append("select *; color lightgrey; backbone 0.1; ");
        ArrayList<List<String>> allPDB = new ArrayList<List<String>>();
        for (int i = 0; i < this.multAln.size(); ++i) {
            List<String> pdb = MultipleAlignmentDisplay.getPDBresnum(i, this.multAln, this.atomArrays.get(i));
            allPDB.add(pdb);
            sel.append("select ");
            int pos = 0;
            for (String res : pdb) {
                if (pos > 0) {
                    sel.append(",");
                }
                ++pos;
                sel.append(res);
                sel.append("/" + (i + 1));
            }
            if (pos == 0) {
                sel.append("none");
            }
            sel.append("; backbone 0.4 ; color [" + colors[i].getRed() + "," + colors[i].getGreen() + "," + colors[i].getBlue() + "]; ");
        }
        j.append(sel);
        j.append("model 0;  ");
        j.append(LIGAND_DISPLAY_SCRIPT);
        StringBuffer buf = new StringBuffer("select ");
        for (int i = 0; i < this.multAln.size(); ++i) {
            int count = 0;
            for (String res : (List)allPDB.get(i)) {
                if (count > 0) {
                    buf.append(",");
                }
                buf.append(res);
                buf.append("/" + (i + 1));
                ++count;
            }
            if (i == this.multAln.size() - 1) continue;
            buf.append(",");
        }
        j.append(buf);
        return j.toString();
    }

    private String getMultiBlockJmolString() {
        StringWriter jmol = new StringWriter();
        jmol.append(DEFAULT_SCRIPT);
        jmol.append("select *; color lightgrey; backbone 0.1; ");
        int blockNum = this.multAln.getBlocks().size();
        Color[] colors = this.colorPalette.getColorPalette(blockNum);
        for (int str = 0; str < this.atomArrays.size(); ++str) {
            jmol.append("select */" + (str + 1) + "; color lightgrey; model " + (str + 1) + "; ");
            int index = 0;
            for (BlockSet bs : this.multAln.getBlockSets()) {
                for (Block b : bs.getBlocks()) {
                    List alignRes = b.getAlignRes();
                    MultipleAlignmentJmol.printJmolScript4Block(this.atomArrays.get(str), alignRes, colors[index], jmol, str, index, blockNum);
                    ++index;
                }
            }
        }
        jmol.append("model 0;  ");
        jmol.append(LIGAND_DISPLAY_SCRIPT);
        return jmol.toString();
    }

    private static void printJmolScript4Block(Atom[] atoms, List<List<Integer>> alignRes, Color blockColor, StringWriter jmol, int str, int colorPos, int blockNum) {
        ArrayList<String> pdb = new ArrayList<String>();
        for (int i = 0; i < alignRes.get(str).size(); ++i) {
            if (alignRes.get(str).get(i) == null) continue;
            int pos = alignRes.get(str).get(i);
            pdb.add(JmolTools.getPdbInfo(atoms[pos]));
        }
        StringBuffer buf = new StringBuffer("select ");
        int count = 0;
        for (String res : pdb) {
            if (count > 0) {
                buf.append(",");
            }
            buf.append(res);
            buf.append("/" + (str + 1));
            ++count;
        }
        buf.append("; backbone 0.4 ; color [" + blockColor.getRed() + "," + blockColor.getGreen() + "," + blockColor.getBlue() + "]; ");
        jmol.append(buf);
    }

    @Override
    public void resetDisplay() {
        if (this.multAln != null) {
            String script = this.getJmolString();
            this.evalString(script);
            this.jmolPanel.evalString("hide ligand");
            this.jmolPanel.evalString("save STATE state_1");
        }
    }

    @Override
    public List<Matrix> getDistanceMatrices() {
        if (this.multAln == null) {
            return null;
        }
        return this.multAln.getEnsemble().getDistanceMatrix();
    }
}

