/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.gui.util.ChooseDirAction;
import org.biojava.nbio.structure.gui.util.StructurePairSelector;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDBDirPanel
extends JPanel
implements StructurePairSelector {
    private static final long serialVersionUID = -5682120627824627408L;
    boolean debug = true;
    JTextField pdbDir;
    JTextField f1;
    JTextField f2;
    JTextField c1;
    JTextField c2;
    private static final Logger logger = LoggerFactory.getLogger(StructurePairSelector.class);

    public PDBDirPanel() {
        Box vBox = Box.createVerticalBox();
        this.pdbDir = new JTextField(20);
        String conf = System.getProperty("PDB_DIR");
        if (conf != null) {
            this.pdbDir.setText(conf);
        }
        JPanel dir = this.getPDBDirPanel(this.pdbDir);
        vBox.add(dir);
        int pdbfSize = 4;
        this.f1 = new JTextField(pdbfSize);
        this.c1 = new JTextField(1);
        JPanel p1 = this.getPDBFilePanel(1, this.f1, this.c1);
        vBox.add(p1);
        this.f2 = new JTextField(pdbfSize);
        this.c2 = new JTextField(1);
        JPanel p2 = this.getPDBFilePanel(2, this.f2, this.c2);
        vBox.add(p2);
        this.add(vBox);
    }

    private Structure fromPDB(JTextField f, JTextField c) throws StructureException {
        String pdb = f.getText();
        if (pdb.length() < 4) {
            f.setText("!!!");
            return null;
        }
        String chain = c.getText();
        if (this.debug) {
            System.out.println("file :" + pdb + " " + chain);
        }
        String dir = this.pdbDir.getText();
        PDBFileReader reader = new PDBFileReader(dir);
        if (this.debug) {
            System.out.println("dir: " + dir);
        }
        StructureImpl tmp1 = new StructureImpl();
        try {
            Structure structure1 = reader.getStructureById(pdb);
            if (chain == null || chain.length() == 0) {
                return structure1;
            }
            if (this.debug) {
                System.out.println("using chain " + chain + " for structure " + structure1.getPDBCode());
            }
            Chain c1 = structure1.findChain(chain);
            tmp1.setPDBCode(structure1.getPDBCode());
            tmp1.setPDBHeader(structure1.getPDBHeader());
            tmp1.setPDBCode(structure1.getPDBCode());
            tmp1.addChain(c1);
            System.out.println("ok");
        }
        catch (IOException e) {
            logger.warn(e.getMessage());
            throw new StructureException((Throwable)e);
        }
        return tmp1;
    }

    @Override
    public Structure getStructure1() throws StructureException {
        return this.fromPDB(this.f1, this.c1);
    }

    @Override
    public Structure getStructure2() throws StructureException {
        return this.fromPDB(this.f2, this.c2);
    }

    private JPanel getPDBDirPanel(JTextField f) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        JLabel l01 = new JLabel("Select PDB directory");
        panel.add(l01);
        panel.add(f);
        ChooseDirAction action = new ChooseDirAction(this.pdbDir);
        JButton chooser = new JButton(action);
        panel.add(chooser);
        return panel;
    }

    private JPanel getPDBFilePanel(int pos, JTextField f, JTextField c) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        JLabel l01 = new JLabel("PDB code ");
        panel.add(l01);
        Box hBox11 = Box.createHorizontalBox();
        JLabel l11 = new JLabel(pos + ":");
        f.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        hBox11.add(l11);
        hBox11.add(Box.createVerticalGlue());
        hBox11.add((Component)f, "Center");
        hBox11.add(Box.createVerticalGlue());
        panel.add(hBox11);
        Box hBox21 = Box.createHorizontalBox();
        JLabel l21 = new JLabel("Chain" + pos + ":");
        c.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        hBox21.add(l21);
        hBox21.add(Box.createGlue());
        hBox21.add((Component)c, "Center");
        hBox21.add(Box.createGlue());
        panel.add(hBox21);
        return panel;
    }
}

