/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.gui.autosuggest.JAutoSuggest;
import org.biojava.nbio.structure.align.gui.autosuggest.SCOPAutoSuggestProvider;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.WebStartMain;
import org.biojava.nbio.structure.gui.util.StructurePairSelector;

public class ScopSelectPanel
extends JPanel
implements StructurePairSelector {
    private static final long serialVersionUID = 757947454156959178L;
    JAutoSuggest dom1;
    JAutoSuggest dom2;

    public ScopSelectPanel() {
        this(true);
    }

    public ScopSelectPanel(boolean show2boxes) {
        Box vBox = Box.createVerticalBox();
        SCOPAutoSuggestProvider autoSuggesP = new SCOPAutoSuggestProvider();
        this.dom1 = new JAutoSuggest(10);
        this.dom1.setAutoSuggestProvider(autoSuggesP);
        this.dom2 = new JAutoSuggest(10);
        this.dom2.setAutoSuggestProvider(autoSuggesP);
        Box b1 = this.getDomainPanel(1, this.dom1);
        Box b2 = this.getDomainPanel(2, this.dom2);
        vBox.add(b1);
        if (show2boxes) {
            vBox.add(b2);
        }
        this.add(vBox);
    }

    private Box getDomainPanel(int pos, JTextField f) {
        JLabel l01 = new JLabel("SCOP or domain id:");
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createGlue());
        hBox.add(l01);
        JLabel l11 = new JLabel(pos + ":");
        f.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        f.setToolTipText("Provide SCOP ID here. Example: d1zyma1");
        hBox.add(l11);
        hBox.add(Box.createVerticalGlue());
        hBox.add((Component)f, "Center");
        hBox.add(Box.createGlue());
        return hBox;
    }

    @Override
    public Structure getStructure1() throws StructureException {
        String scop1 = this.dom1.getText();
        return this.getStructure(scop1);
    }

    @Override
    public Structure getStructure2() throws StructureException {
        return this.getStructure(this.dom2.getText());
    }

    private Structure getStructure(String domainID) throws StructureException {
        if (domainID == null || domainID.equals("")) {
            return null;
        }
        UserConfiguration config = WebStartMain.getWebStartConfig();
        AtomCache cache = new AtomCache(config);
        cache.setStrictSCOP(false);
        Structure s = null;
        try {
            s = cache.getStructure(domainID);
            s.setName(domainID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }
}

