/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.jmol;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JComboBox;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.gui.JPrintPanel;
import org.biojava.nbio.structure.align.gui.jmol.MyJmolStatusListener;
import org.biojava.nbio.structure.domain.LocalProteinDomainParser;
import org.biojava.nbio.structure.domain.pdp.Domain;
import org.biojava.nbio.structure.domain.pdp.Segment;
import org.biojava.nbio.structure.gui.util.color.ColorUtils;
import org.biojava.nbio.structure.io.mmtf.MmtfActions;
import org.biojava.nbio.structure.jama.Matrix;
import org.biojava.nbio.structure.scop.ScopDomain;
import org.biojava.nbio.structure.scop.ScopInstallation;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.util.LoggerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmolPanel
extends JPrintPanel
implements ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(JmolPanel.class);
    private static final long serialVersionUID = -3661941083797644242L;
    private JmolViewer viewer;
    private JmolAdapter adapter;
    JmolStatusListener statusListener;
    final Dimension currentSize = new Dimension();
    final Rectangle rectClip = new Rectangle();
    Structure structure;

    public JmolPanel() {
        this.statusListener = new MyJmolStatusListener();
        this.adapter = new SmarterJmolAdapter();
        JmolLoggerAdapter jmolLogger = new JmolLoggerAdapter(LoggerFactory.getLogger(JmolViewer.class));
        org.jmol.util.Logger.setLogger((LoggerInterface)jmolLogger);
        org.jmol.util.Logger.setLogLevel((int)jmolLogger.getLogLevel());
        this.viewer = JmolViewer.allocateViewer((Object)this, (JmolAdapter)this.adapter, null, null, null, null, (JmolStatusListener)this.statusListener);
    }

    @Override
    public void paint(Graphics g) {
        this.getSize(this.currentSize);
        g.getClipBounds(this.rectClip);
        this.viewer.renderScreenImage((Object)g, (Object)this.currentSize, (Object)this.rectClip);
    }

    public void evalString(String rasmolScript) {
        this.viewer.evalString(rasmolScript);
    }

    public void openStringInline(String pdbFile) {
        this.viewer.openStringInline(pdbFile);
    }

    public JmolViewer getViewer() {
        return this.viewer;
    }

    public JmolAdapter getAdapter() {
        return this.adapter;
    }

    public JmolStatusListener getStatusListener() {
        return this.statusListener;
    }

    public void executeCmd(String rasmolScript) {
        this.viewer.evalString(rasmolScript);
    }

    public void setStructure(Structure s) {
        this.structure = s;
        try (PipedOutputStream out = new PipedOutputStream();
             BufferedInputStream in = new BufferedInputStream(new PipedInputStream(out));){
            new Thread(() -> {
                try {
                    MmtfActions.writeToOutputStream((Structure)s, (OutputStream)out);
                }
                catch (Exception e) {
                    logger.error("Error generating MMTF output for {}", (Object)(s.getStructureIdentifier() == null ? s.getStructureIdentifier().getIdentifier() : s.getName()), (Object)e);
                }
            }).start();
            this.viewer.openReader(null, (Object)in);
        }
        catch (IOException e) {
            logger.error("Error transfering {} to Jmol", (Object)(s.getStructureIdentifier() == null ? s.getStructureIdentifier().getIdentifier() : s.getName()), (Object)e);
        }
        this.evalString("save STATE state_1");
    }

    public void jmolColorByChain() {
        String script = "function color_by_chain(objtype, color_list) {" + String.format("%n", new Object[0]) + "" + String.format("%n", new Object[0]) + "\t\t if (color_list) {" + String.format("%n", new Object[0]) + "\t\t   if (color_list.type == \"string\") {" + String.format("%n", new Object[0]) + "\t\t     color_list = color_list.split(\",\").trim();" + String.format("%n", new Object[0]) + "\t\t   }" + String.format("%n", new Object[0]) + "\t\t } else {" + String.format("%n", new Object[0]) + "\t\t   color_list = [\"104BA9\",\"AA00A2\",\"C9F600\",\"FFA200\",\"284A7E\",\"7F207B\",\"9FB82E\",\"BF8B30\",\"052D6E\",\"6E0069\",\"83A000\",\"A66A00\",\"447BD4\",\"D435CD\",\"D8FA3F\",\"FFBA40\",\"6A93D4\",\"D460CF\",\"E1FA71\",\"FFCC73\"];" + String.format("%n", new Object[0]) + "\t\t }" + String.format("%n", new Object[0]) + "\t\t var cmd2 = \"\";" + String.format("%n", new Object[0]) + "\t\t if (!objtype) {" + String.format("%n", new Object[0]) + "\t\t   var type_list  = [ \"backbone\",\"cartoon\",\"dots\",\"halo\",\"label\",\"meshribbon\",\"polyhedra\",\"rocket\",\"star\",\"strand\",\"strut\",\"trace\"];" + String.format("%n", new Object[0]) + "\t\t   cmd2 = \"color \" + type_list.join(\" none; color \") + \" none;\";" + String.format("%n", new Object[0]) + "\t\t   objtype = \"atoms\";" + String.format("%n", new Object[0]) + "\t\t }" + String.format("%n", new Object[0]) + "\t\t var chain_list  = script(\"show chain\").trim().lines;" + String.format("%n", new Object[0]) + "\t\t var chain_count = chain_list.length;" + String.format("%n", new Object[0]) + "\t\t var color_count = color_list.length;" + String.format("%n", new Object[0]) + "\t\t var sel = {selected};" + String.format("%n", new Object[0]) + "\t\t var cmds = \"\";" + String.format("%n", new Object[0]) + "\t\t for (var chain_number=1; chain_number<=chain_count; chain_number++) {" + String.format("%n", new Object[0]) + "\t\t   // remember, Jmol arrays start with 1, but % can return 0" + String.format("%n", new Object[0]) + "\t\t   cmds += \"select sel and :\" + chain_list[chain_number] + \";color \" + objtype + \" [x\" + color_list[(chain_number-1) % color_count + 1] + \"];\" + cmd2;" + String.format("%n", new Object[0]) + "\t\t }" + String.format("%n", new Object[0]) + "\t\t script INLINE @{cmds + \"select sel\"}" + String.format("%n", new Object[0]) + "}";
        this.executeCmd(script);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object mysource = event.getSource();
        if (!(mysource instanceof JComboBox)) {
            super.actionPerformed(event);
            return;
        }
        JComboBox source = (JComboBox)event.getSource();
        String value = source.getSelectedItem().toString();
        this.evalString("save selection; ");
        String selectLigand = "select ligand;wireframe 0.16;spacefill 0.5; color cpk ;";
        if (value.equals("Cartoon")) {
            String script = "hide null; select all;  spacefill off; wireframe off; backbone off; cartoon on;  select ligand; wireframe 0.16;spacefill 0.5; color cpk;  select *.FE; spacefill 0.7; color cpk ;  select *.CU; spacefill 0.7; color cpk ;  select *.ZN; spacefill 0.7; color cpk ;  select all; ";
            this.executeCmd(script);
        } else if (value.equals("Backbone")) {
            String script = "hide null; select all; spacefill off; wireframe off; backbone 0.4; cartoon off;  select ligand; wireframe 0.16;spacefill 0.5; color cpk;  select *.FE; spacefill 0.7; color cpk ;  select *.CU; spacefill 0.7; color cpk ;  select *.ZN; spacefill 0.7; color cpk ;  select all; ";
            this.executeCmd(script);
        } else if (value.equals("CPK")) {
            String script = "hide null; select all; spacefill off; wireframe off; backbone off; cartoon off; cpk on; select ligand; wireframe 0.16;spacefill 0.5; color cpk;  select *.FE; spacefill 0.7; color cpk ;  select *.CU; spacefill 0.7; color cpk ;  select *.ZN; spacefill 0.7; color cpk ;  select all; ";
            this.executeCmd(script);
        } else if (value.equals("Ligands")) {
            this.executeCmd("restrict ligand; cartoon off; wireframe on;  display selected;");
        } else if (value.equals("Ligands and Pocket")) {
            this.executeCmd(" select within (6.0,ligand); cartoon off; wireframe on; backbone off; display selected; ");
        } else if (value.equals("Ball and Stick")) {
            String script = "hide null; restrict not water;  wireframe 0.2; spacefill 25%; cartoon off; backbone off;  select ligand; wireframe 0.16; spacefill 0.5; color cpk;  select *.FE; spacefill 0.7; color cpk ;  select *.CU; spacefill 0.7; color cpk ;  select *.ZN; spacefill 0.7; color cpk ;  select all; ";
            this.executeCmd(script);
        } else if (value.equals("By Chain")) {
            this.jmolColorByChain();
            String script = "hide null; select all;set defaultColors Jmol; color_by_chain(\"cartoon\"); color_by_chain(\"\"); " + selectLigand + "; select all; ";
            this.executeCmd(script);
        } else if (value.equals("Rainbow")) {
            this.executeCmd("hide null; select all; set defaultColors Jmol; color group; color cartoon group; " + selectLigand + "; select all; ");
        } else if (value.equals("Secondary Structure")) {
            this.executeCmd("hide null; select all; set defaultColors Jmol; color structure; color cartoon structure;" + selectLigand + "; select all; ");
        } else if (value.equals("By Element")) {
            this.executeCmd("hide null; select all; set defaultColors Jmol; color cpk; color cartoon cpk; " + selectLigand + "; select all; ");
        } else if (value.equals("By Amino Acid")) {
            this.executeCmd("hide null; select all; set defaultColors Jmol; color amino; color cartoon amino; " + selectLigand + "; select all; ");
        } else if (value.equals("Hydrophobicity")) {
            this.executeCmd("hide null; set defaultColors Jmol; select hydrophobic; color red; color cartoon red; select not hydrophobic ; color blue ; color cartoon blue; " + selectLigand + "; select all; ");
        } else if (value.equals("Suggest Domains")) {
            this.colorByPDP();
        } else if (value.equals("Show SCOP Domains")) {
            this.colorBySCOP();
        }
        this.evalString("restore selection; ");
    }

    private void colorBySCOP() {
        if (this.structure == null) {
            return;
        }
        String pdbId = this.structure.getPDBCode();
        if (pdbId == null) {
            return;
        }
        ScopInstallation scop = new ScopInstallation();
        List domains = scop.getDomainsForPDB(pdbId);
        if (domains == null) {
            System.err.println("No SCOP domains found for " + pdbId);
            return;
        }
        int i = -1;
        for (ScopDomain domain : domains) {
            if (++i >= ColorUtils.colorWheel.length) {
                i = 0;
            }
            Color c1 = ColorUtils.colorWheel[i];
            List ranges = domain.getRanges();
            for (String range : ranges) {
                logger.debug(range);
                String[] spl = range.split(":");
                String script = " select  ";
                script = spl.length > 1 ? script + spl[1] + ":" + spl[0] + "/1;" : script + "*" + spl[0] + "/1;";
                script = script + " color [" + c1.getRed() + "," + c1.getGreen() + "," + c1.getBlue() + "];";
                script = script + " color cartoon [" + c1.getRed() + "," + c1.getGreen() + "," + c1.getBlue() + "] ;";
                logger.debug(script);
                this.evalString(script);
            }
        }
    }

    private void colorByPDP() {
        logger.debug("colorByPDP");
        if (this.structure == null) {
            return;
        }
        try {
            Atom[] ca = StructureTools.getRepresentativeAtomArray((Structure)this.structure);
            List domains = LocalProteinDomainParser.suggestDomains((Atom[])ca);
            int i = -1;
            for (Domain dom : domains) {
                if (++i > ColorUtils.colorWheel.length) {
                    i = 0;
                }
                List segments = dom.getSegments();
                Color c1 = ColorUtils.colorWheel[i];
                for (Segment s : segments) {
                    int start = s.getFrom();
                    int end = s.getTo();
                    Group startG = ca[start].getGroup();
                    Group endG = ca[end].getGroup();
                    logger.debug("   Segment: " + startG.getResidueNumber() + ":" + startG.getChainId() + " - " + endG.getResidueNumber() + ":" + endG.getChainId() + " " + s);
                    String j1 = startG.getResidueNumber() + "";
                    String j2 = endG.getResidueNumber() + ":" + endG.getChainId();
                    String script = " select  " + j1 + "-" + j2 + "/1;";
                    script = script + " color [" + c1.getRed() + "," + c1.getGreen() + "," + c1.getBlue() + "];";
                    script = script + " color cartoon [" + c1.getRed() + "," + c1.getGreen() + "," + c1.getBlue() + "] ;";
                    logger.debug(script);
                    this.evalString(script);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rotateJmol(Matrix jmolRotation) {
        if (jmolRotation != null) {
            double[] zyz = Calc.getZYZEuler((Matrix)jmolRotation);
            DecimalFormat df = new DecimalFormat("0.##");
            String script = "reset; rotate z " + df.format(zyz[0]) + "; rotate y " + df.format(zyz[1]) + "; rotate z " + df.format(zyz[2]) + ";";
            this.executeCmd(script);
        }
    }

    public void destroy() {
        this.executeCmd("zap;");
        this.structure = null;
        this.viewer = null;
        this.adapter = null;
    }

    public static class JmolLoggerAdapter
    implements LoggerInterface {
        private Logger slf;

        public JmolLoggerAdapter(Logger slf) {
            this.slf = slf;
        }

        public int getLogLevel() {
            if (this.slf.isTraceEnabled()) {
                return 7;
            }
            if (this.slf.isDebugEnabled()) {
                return 5;
            }
            if (this.slf.isInfoEnabled()) {
                return 4;
            }
            if (this.slf.isWarnEnabled()) {
                return 3;
            }
            if (this.slf.isErrorEnabled()) {
                return 2;
            }
            throw new IllegalStateException("Unknown SLF4J error level");
        }

        public void debug(String txt) {
            this.slf.debug(txt);
        }

        public void info(String txt) {
            this.slf.info(txt);
        }

        public void warn(String txt) {
            this.slf.warn(txt);
        }

        public void warnEx(String txt, Throwable e) {
            this.slf.warn(txt, e);
        }

        public void error(String txt) {
            this.slf.error(txt);
        }

        public void errorEx(String txt, Throwable e) {
            this.slf.error(txt, e);
        }

        public void fatal(String txt) {
            this.slf.error(txt);
        }

        public void fatalEx(String txt, Throwable e) {
            this.slf.error(txt, e);
        }
    }
}

