/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.gui.MenuCreator;
import org.biojava.nbio.structure.gui.RenderStyle;
import org.biojava.nbio.structure.gui.Selection;
import org.biojava.nbio.structure.gui.StructureViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmolViewerImpl
implements StructureViewer {
    private static final Logger logger = LoggerFactory.getLogger(JmolViewerImpl.class);
    public static final String viewer = "org.jmol.api.JmolSimpleViewer";
    public static final String adapter = "org.jmol.api.JmolAdapter";
    public static final String smartAdapter = "org.jmol.adapter.smarter.SmarterJmolAdapter";
    Structure structure;
    JmolPanel jmolPanel;
    JFrame frame = new JFrame();

    public JmolViewerImpl() {
        JMenuBar menu = MenuCreator.initJmolMenu(this.frame, null, null, null);
        this.frame.setJMenuBar(menu);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JmolViewerImpl.this.frame.dispose();
            }
        });
        Container contentPane = this.frame.getContentPane();
        Box vBox = Box.createVerticalBox();
        try {
            this.jmolPanel = new JmolPanel();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println("Could not find Jmol in classpath, please install first. http://www.jmol.org");
            return;
        }
        this.jmolPanel.setPreferredSize(new Dimension(500, 500));
        vBox.add(this.jmolPanel);
        JTextField field = new JTextField();
        field.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        field.setText("enter RASMOL like command...");
        vBox.add(field);
        contentPane.add(vBox);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void setTitle(String label) {
        this.frame.setTitle(label);
        this.frame.repaint();
    }

    @Override
    public void setStructure(Structure structure) {
        if (this.jmolPanel == null) {
            System.err.println("please install Jmol first");
            return;
        }
        this.setTitle(structure.getPDBCode());
        String pdb = structure.toPDB();
        this.jmolPanel.openStringInline(pdb);
    }

    @Override
    public void clear() {
    }

    @Override
    public Color getColor() {
        return null;
    }

    @Override
    public Selection getSelection() {
        return null;
    }

    @Override
    public void repaint() {
    }

    @Override
    public void setColor(Color red) {
    }

    @Override
    public void setSelection(Selection selection) {
    }

    @Override
    public void setStyle(RenderStyle wireframe) {
    }

    @Override
    public void setZoom(int i) {
    }

    static class JmolPanel
    extends JPanel {
        private static final long serialVersionUID = -3661941083797644242L;
        Class viewerC;
        Class adapterC;
        Class smartAdapterC;
        Object viewerO;
        Object adapterO;
        Method evalString;
        Method renderScreenImage;
        Method openStringInline;
        final Dimension currentSize = new Dimension();
        final Rectangle rectClip = new Rectangle();

        JmolPanel() throws ClassNotFoundException {
            try {
                this.viewerC = Class.forName(JmolViewerImpl.viewer);
                this.adapterC = Class.forName(JmolViewerImpl.adapter);
                this.smartAdapterC = Class.forName(JmolViewerImpl.smartAdapter);
                Method m = this.viewerC.getMethod("allocateSimpleViewer", Component.class, this.adapterC);
                Constructor constructor = this.smartAdapterC.getConstructor(new Class[0]);
                this.adapterO = constructor.newInstance(new Object[0]);
                this.viewerO = m.invoke((Object)this.viewerC, this, this.adapterO);
                this.evalString = this.viewerC.getMethod("evalString", String.class);
                this.renderScreenImage = this.viewerC.getMethod("renderScreenImage", Graphics.class, Dimension.class, Rectangle.class);
                this.openStringInline = this.viewerC.getMethod("openStringInline", String.class);
            }
            catch (InstantiationException ex) {
                logger.error("Exception caught", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                logger.error("Exception caught", (Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                logger.error("Exception caught", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                logger.error("Exception caught", (Throwable)ex);
            }
            catch (NoSuchMethodException e) {
                logger.error("Exception caught", (Throwable)e);
            }
            this.evalString("set scriptQueue on;");
        }

        public Class getViewer() {
            return this.viewerC;
        }

        public void evalString(String rasmolScript) {
            try {
                this.evalString.invoke(this.viewerO, rasmolScript);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void openStringInline(String pdbFile) {
            try {
                this.openStringInline.invoke(this.viewerO, pdbFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void executeCmd(String rasmolScript) {
            try {
                this.evalString.invoke(this.viewerO, rasmolScript);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void paint(Graphics g) {
            this.getSize(this.currentSize);
            g.getClipBounds(this.rectClip);
            try {
                this.renderScreenImage.invoke(this.viewerO, g, this.currentSize, this.rectClip);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

