/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.jmol;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.align.gui.MenuCreator;
import org.biojava.nbio.structure.align.gui.MultipleAlignmentGUI;
import org.biojava.nbio.structure.align.gui.MultipleAlignmentJmolDisplay;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.JmolPanel;
import org.biojava.nbio.structure.align.gui.jmol.JmolTools;
import org.biojava.nbio.structure.align.gui.jmol.MyJmolStatusListener;
import org.biojava.nbio.structure.align.gui.jmol.RasmolCommandListener;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentTools;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentWriter;
import org.biojava.nbio.structure.align.webstart.AligUIManager;
import org.biojava.nbio.structure.gui.WrapLayout;
import org.biojava.nbio.structure.jama.Matrix;
import org.forester.archaeopteryx.Archaeopteryx;
import org.forester.phylogeny.Phylogeny;
import org.jcolorbrewer.ColorBrewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleAlignmentJmol
extends AbstractAlignmentJmol {
    private MultipleAlignment multAln;
    private List<Atom[]> transformedAtoms;
    private JCheckBox colorByBlocks;
    private List<JCheckBox> selectedStructures;
    private static final String LIGAND_DISPLAY_SCRIPT = "select ligand; wireframe 40; spacefill 120; color CPK;";
    private static final Logger logger = LoggerFactory.getLogger(MultipleAlignmentJmol.class);

    public MultipleAlignmentJmol() {
        this(null, null);
    }

    public MultipleAlignmentJmol(MultipleAlignment msa, List<Atom[]> rotatedAtoms) {
        AligUIManager.setLookAndFeel();
        ++nrOpenWindows;
        this.jmolPanel = new JmolPanel();
        this.frame = new JFrame();
        JMenuBar menu = MenuCreator.initJmolMenu(this.frame, this, null, msa);
        this.frame.setJMenuBar(menu);
        this.multAln = msa;
        this.transformedAtoms = rotatedAtoms;
        this.selectedStructures = new ArrayList<JCheckBox>();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MultipleAlignmentJmol.this.destroy();
                if (--AbstractAlignmentJmol.nrOpenWindows > 0) {
                    MultipleAlignmentJmol.this.frame.dispose();
                } else {
                    MultipleAlignmentGUI gui = MultipleAlignmentGUI.getInstanceNoVisibilityChange();
                    if (gui.isVisible()) {
                        MultipleAlignmentJmol.this.frame.dispose();
                        gui.requestFocus();
                    } else {
                        System.exit(0);
                    }
                }
            }
        });
        Container contentPane = this.frame.getContentPane();
        this.jmolPanel.addMouseMotionListener(this);
        this.jmolPanel.addMouseListener(this);
        this.jmolPanel.setPreferredSize(new Dimension(500, 500));
        contentPane.add((Component)this.jmolPanel, "Center");
        Box vBox = Box.createVerticalBox();
        JTextField field = new JTextField();
        field.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        field.setText("enter Jmol scripting command...");
        RasmolCommandListener listener = new RasmolCommandListener(this.jmolPanel, field);
        field.addActionListener(listener);
        field.addMouseListener(listener);
        field.addKeyListener(listener);
        vBox.add(field);
        if (this.multAln != null) {
            JPanel modelSelection = new JPanel();
            modelSelection.setLayout(new WrapLayout(0));
            modelSelection.setSize(new Dimension(500, 30));
            vBox.add(modelSelection);
            JButton show = new JButton("Show Only: ");
            show.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultipleAlignmentJmol.this.jmolPanel.evalString("save selection;");
                    String cmd = MultipleAlignmentJmol.getJmolString(MultipleAlignmentJmol.this.multAln, MultipleAlignmentJmol.this.transformedAtoms, MultipleAlignmentJmol.this.colorPalette, MultipleAlignmentJmol.this.colorByBlocks.isSelected());
                    cmd = cmd + "; restrict ";
                    for (int st = 0; st < MultipleAlignmentJmol.this.multAln.size(); ++st) {
                        if (!((JCheckBox)MultipleAlignmentJmol.this.selectedStructures.get(st)).isSelected()) continue;
                        cmd = cmd + "*/" + (st + 1) + ", ";
                    }
                    cmd = cmd + "none;";
                    MultipleAlignmentJmol.this.jmolPanel.executeCmd(cmd + " restore selection;");
                }
            });
            modelSelection.add(show);
            for (int str = 0; str < this.multAln.size(); ++str) {
                JCheckBox structureSelection = new JCheckBox(((StructureIdentifier)this.multAln.getEnsemble().getStructureIdentifiers().get(str)).getIdentifier());
                modelSelection.add(structureSelection);
                structureSelection.setSelected(true);
                this.selectedStructures.add(structureSelection);
            }
        }
        Box hBox1 = Box.createHorizontalBox();
        hBox1.add(Box.createGlue());
        String[] styles = new String[]{"Cartoon", "Backbone", "CPK", "Ball and Stick", "Ligands", "Ligands and Pocket"};
        JComboBox<String> style = new JComboBox<String>(styles);
        hBox1.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        hBox1.add(new JLabel("Style"));
        hBox1.add(style);
        vBox.add(hBox1);
        style.addActionListener(this.jmolPanel);
        String[] colorModes = new String[]{"Secondary Structure", "By Chain", "Rainbow", "By Element", "By Amino Acid", "Hydrophobicity", "Suggest Domains", "Show SCOP Domains"};
        JComboBox<String> jcolors = new JComboBox<String>(colorModes);
        jcolors.addActionListener(this.jmolPanel);
        hBox1.add(Box.createGlue());
        hBox1.add(new JLabel("Color"));
        hBox1.add(jcolors);
        String[] cPalette = new String[]{"Spectral", "Set1", "Set2", "Pastel"};
        JComboBox<String> palette = new JComboBox<String>(cPalette);
        palette.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                String value = source.getSelectedItem().toString();
                MultipleAlignmentJmol.this.evalString("save selection; select *; color grey; select ligand; color CPK;");
                if (value == "Set1") {
                    MultipleAlignmentJmol.this.colorPalette = ColorBrewer.Set1;
                } else if (value == "Set2") {
                    MultipleAlignmentJmol.this.colorPalette = ColorBrewer.Set2;
                } else if (value == "Spectral") {
                    MultipleAlignmentJmol.this.colorPalette = ColorBrewer.Spectral;
                } else if (value == "Pastel") {
                    MultipleAlignmentJmol.this.colorPalette = ColorBrewer.Pastel1;
                }
                String script = MultipleAlignmentJmol.getJmolString(MultipleAlignmentJmol.this.multAln, MultipleAlignmentJmol.this.transformedAtoms, MultipleAlignmentJmol.this.colorPalette, MultipleAlignmentJmol.this.colorByBlocks.isSelected());
                MultipleAlignmentJmol.this.evalString(script + "; restore selection; ");
            }
        });
        hBox1.add(Box.createGlue());
        hBox1.add(new JLabel("Palette"));
        hBox1.add(palette);
        Box hBox2 = Box.createHorizontalBox();
        hBox2.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        JButton resetDisplay = new JButton("Reset Display");
        resetDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.info("reset!!");
                MultipleAlignmentJmol.this.jmolPanel.executeCmd("restore STATE state_1");
            }
        });
        hBox2.add(resetDisplay);
        hBox2.add(Box.createGlue());
        JCheckBox toggleSelection = new JCheckBox("Show Selection");
        toggleSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean showSelection;
                boolean bl = showSelection = e.getStateChange() == 1;
                if (showSelection) {
                    MultipleAlignmentJmol.this.jmolPanel.executeCmd("set display selected");
                } else {
                    MultipleAlignmentJmol.this.jmolPanel.executeCmd("set display off");
                }
            }
        });
        hBox2.add(toggleSelection);
        hBox2.add(Box.createGlue());
        this.colorByBlocks = new JCheckBox("Color By Block");
        this.colorByBlocks.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MultipleAlignmentJmol.this.evalString("save selection; " + MultipleAlignmentJmol.getJmolString(MultipleAlignmentJmol.this.multAln, MultipleAlignmentJmol.this.transformedAtoms, MultipleAlignmentJmol.this.colorPalette, MultipleAlignmentJmol.this.colorByBlocks.isSelected()) + "; restore selection;");
            }
        });
        hBox2.add(this.colorByBlocks);
        hBox2.add(Box.createGlue());
        vBox.add(hBox2);
        Box hBox = Box.createHorizontalBox();
        this.status = new JTextField();
        this.status.setBackground(Color.white);
        this.status.setEditable(false);
        this.status.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.status.setPreferredSize(new Dimension(250, 30));
        this.status.setMinimumSize(new Dimension(250, 30));
        hBox.add(this.status);
        this.text = new JTextField();
        this.text.setBackground(Color.white);
        this.text.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.text.setPreferredSize(new Dimension(250, 30));
        this.text.setMinimumSize(new Dimension(250, 30));
        this.text.setText("Display of Atom info");
        this.text.setEditable(false);
        hBox.add(this.text);
        vBox.add(hBox);
        contentPane.add((Component)vBox, "South");
        MyJmolStatusListener li = (MyJmolStatusListener)this.jmolPanel.getStatusListener();
        li.setTextField(this.status);
        this.frame.pack();
        this.frame.setVisible(true);
        this.initCoords();
        this.resetDisplay();
    }

    @Override
    protected void initCoords() {
        try {
            if (this.multAln == null) {
                if (this.structure != null) {
                    this.setStructure(this.structure);
                } else {
                    logger.error("Could not find anything to display!");
                    return;
                }
            }
            Structure artificial = MultipleAlignmentTools.toMultimodelStructure((MultipleAlignment)this.multAln, this.transformedAtoms);
            this.setStructure(artificial);
            logger.info(artificial.getPDBHeader().getTitle());
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.multAln = null;
        this.transformedAtoms = null;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (this.multAln == null) {
            logger.error("Currently not viewing an alignment!");
            return;
        }
        try {
            if (cmd.equals("View Text Only")) {
                logger.warn("Option not available for MultipleAlignments");
            } else if (cmd.equals("View Aligned Pairs")) {
                String result = MultipleAlignmentWriter.toAlignedResidues((MultipleAlignment)this.multAln);
                MultipleAlignmentJmolDisplay.showAlignmentImage(this.multAln, result);
            } else if (cmd.equals("Alignment Panel")) {
                MultipleAlignmentJmolDisplay.showMultipleAligmentPanel(this.multAln, this);
            } else if (cmd.equals("View as FATCAT result")) {
                String result = MultipleAlignmentWriter.toFatCat((MultipleAlignment)this.multAln) + "\n";
                result = result + MultipleAlignmentWriter.toTransformMatrices((MultipleAlignment)this.multAln);
                MultipleAlignmentJmolDisplay.showAlignmentImage(this.multAln, result);
            } else if (cmd.equals("Phylogenetic Tree")) {
                Phylogeny kimura = MultipleAlignmentTools.getKimuraTree((MultipleAlignment)this.multAln);
                Phylogeny sdm = MultipleAlignmentTools.getHSDMTree((MultipleAlignment)this.multAln);
                Archaeopteryx.createApplication((Phylogeny[])new Phylogeny[]{kimura, sdm});
            }
        }
        catch (Exception e) {
            logger.error("Could not complete display option.", (Throwable)e);
        }
    }

    public static String getJmolString(MultipleAlignment multAln, List<Atom[]> transformedAtoms, ColorBrewer colorPalette, boolean colorByBlocks) {
        if (colorByBlocks) {
            return MultipleAlignmentJmol.getMultiBlockJmolString(multAln, transformedAtoms, colorPalette, colorByBlocks);
        }
        Color[] colors = colorPalette.getColorPalette(multAln.size());
        StringBuffer j = new StringBuffer();
        j.append(DEFAULT_SCRIPT);
        StringBuffer sel = new StringBuffer();
        sel.append("select *; color lightgrey; backbone 0.1; ");
        ArrayList<List<String>> allPDB = new ArrayList<List<String>>();
        for (int i = 0; i < multAln.size(); ++i) {
            List<String> pdb = MultipleAlignmentJmolDisplay.getPDBresnum(i, multAln, transformedAtoms.get(i));
            allPDB.add(pdb);
            sel.append("select ");
            int pos = 0;
            for (String res : pdb) {
                if (pos > 0) {
                    sel.append(",");
                }
                ++pos;
                sel.append(res);
                sel.append("/" + (i + 1));
            }
            if (pos == 0) {
                sel.append("none");
            }
            sel.append("; backbone 0.3 ; color [" + colors[i].getRed() + "," + colors[i].getGreen() + "," + colors[i].getBlue() + "]; ");
        }
        j.append(sel);
        j.append("model 0;  ");
        j.append(LIGAND_DISPLAY_SCRIPT);
        return j.toString();
    }

    public static String getMultiBlockJmolString(MultipleAlignment multAln, List<Atom[]> transformedAtoms, ColorBrewer colorPalette, boolean colorByBlocks) {
        StringWriter jmol = new StringWriter();
        jmol.append(DEFAULT_SCRIPT);
        jmol.append("select *; color lightgrey; backbone 0.1; ");
        int blockNum = multAln.getBlocks().size();
        Color[] colors = colorPalette.getColorPalette(blockNum);
        for (int str = 0; str < transformedAtoms.size(); ++str) {
            jmol.append("select */" + (str + 1) + "; color lightgrey; model " + (str + 1) + "; ");
            int index = 0;
            for (BlockSet bs : multAln.getBlockSets()) {
                for (Block b : bs.getBlocks()) {
                    List alignRes = b.getAlignRes();
                    MultipleAlignmentJmol.printJmolScript4Block(transformedAtoms.get(str), alignRes, colors[index], jmol, str, index, blockNum);
                    ++index;
                }
            }
        }
        jmol.append("model 0;  ");
        jmol.append(LIGAND_DISPLAY_SCRIPT);
        return jmol.toString();
    }

    private static void printJmolScript4Block(Atom[] atoms, List<List<Integer>> alignRes, Color blockColor, StringWriter jmol, int str, int colorPos, int blockNum) {
        ArrayList<String> pdb = new ArrayList<String>();
        for (int i = 0; i < alignRes.get(str).size(); ++i) {
            if (alignRes.get(str).get(i) == null) continue;
            int pos = alignRes.get(str).get(i);
            pdb.add(JmolTools.getPdbInfo(atoms[pos]));
        }
        StringBuffer buf = new StringBuffer("select ");
        int count = 0;
        for (String res : pdb) {
            if (count > 0) {
                buf.append(",");
            }
            buf.append(res);
            buf.append("/" + (str + 1));
            ++count;
        }
        buf.append("; backbone 0.3 ; color [" + blockColor.getRed() + "," + blockColor.getGreen() + "," + blockColor.getBlue() + "]; ");
        jmol.append(buf);
    }

    @Override
    public void resetDisplay() {
        if (this.multAln != null && this.transformedAtoms != null) {
            String script = MultipleAlignmentJmol.getJmolString(this.multAln, this.transformedAtoms, this.colorPalette, this.colorByBlocks.isSelected());
            logger.debug(script);
            this.evalString(script);
            this.jmolPanel.evalString("save STATE state_1");
        }
    }

    @Override
    public List<Matrix> getDistanceMatrices() {
        if (this.multAln == null) {
            return null;
        }
        return this.multAln.getEnsemble().getDistanceMatrix();
    }

    public void setColorByBlocks(boolean colorByBlocks) {
        this.colorByBlocks.setSelected(colorByBlocks);
        this.resetDisplay();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public MultipleAlignment getMultipleAlignment() {
        return this.multAln;
    }
}

