/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.aligpanel;

import java.awt.Point;
import org.biojava.nbio.structure.align.model.AFPChain;

public class AFPChainCoordManager {
    AFPChain afpChain;
    public static final int DEFAULT_RIGHT_SPACER = 10;
    public static final int DEFAULT_LINE_LENGTH = 70;
    public static final int DEFAULT_Y_STEP = 60;
    public static final int DEFAULT_CHAR_SIZE = 12;
    public static final int DEFAULT_LINE_SEPARATION = 20;
    public static final int DEFAULT_X_SPACE = 20;
    public static final int DEFAULT_Y_SPACE = 40;
    public static final int SUMMARY_POS = 20;
    private static final int DEFAULT_LEGEND_SIZE = 50;

    public int getSummaryPos() {
        return 20;
    }

    public int getPreferredWidth() {
        return 990;
    }

    public int getPreferredHeight() {
        return 80 + this.afpChain.getAlnLength() / 70 * 60 + 20;
    }

    public int getSeqPos(int aligSeq, Point p) {
        int x = p.x - 20 - 50;
        int y = p.y - 40;
        int lineNr = (y -= 20 * aligSeq - 12) / 60;
        int linePos = x / 12;
        return lineNr * 70 + linePos;
    }

    public Point getPanelPos(int aligSeq, int i) {
        Point p = new Point();
        int lineNr = i / 70;
        int linePos = i % 70;
        int x = linePos * 12 + 20 + 50;
        int y = lineNr * 60 + 40;
        p.setLocation(x, y += 20 * aligSeq);
        return p;
    }

    public void setAFPChain(AFPChain afpChain) {
        this.afpChain = afpChain;
    }

    public int getAligSeq(Point point) {
        int i1 = this.getSeqPos(0, point);
        Point t1 = this.getPanelPos(0, i1);
        if (Math.abs(t1.x - point.x) <= 12 && Math.abs(t1.y - point.y) < 12) {
            return 0;
        }
        int i2 = this.getSeqPos(1, point);
        Point t2 = this.getPanelPos(1, i2);
        if (Math.abs(t2.x - point.x) < 12 && Math.abs(t2.y - point.y) < 12) {
            return 1;
        }
        return -1;
    }

    public Point getLegendPosition(int lineNr, int chainNr) {
        int x = 20;
        int y = lineNr * 60 + 40;
        Point p = new Point(x, y += chainNr * 20);
        return p;
    }

    public Point getEndLegendPosition(int lineNr, int chainNr) {
        int x = 920;
        int y = lineNr * 60 + 40;
        Point p = new Point(x, y += chainNr * 20);
        return p;
    }
}

