/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.jmolScript;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import org.biojava.nbio.structure.symmetry.axis.AxisAligner;
import org.biojava.nbio.structure.symmetry.axis.HelixAxisAligner;
import org.biojava.nbio.structure.symmetry.axis.RotationAxisAligner;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGeneratorC1;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGeneratorCn;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGeneratorDn;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGeneratorH;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGeneratorI;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGeneratorO;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGeneratorT;

public abstract class JmolSymmetryScriptGenerator {
    public static JmolSymmetryScriptGenerator getInstance(AxisAligner axisAligner, String name) {
        String symmetry = axisAligner.getSymmetry();
        if (symmetry.equals("C1")) {
            return new JmolSymmetryScriptGeneratorC1((RotationAxisAligner)axisAligner, name);
        }
        if (symmetry.startsWith("C")) {
            return new JmolSymmetryScriptGeneratorCn((RotationAxisAligner)axisAligner, name);
        }
        if (symmetry.startsWith("D")) {
            return new JmolSymmetryScriptGeneratorDn((RotationAxisAligner)axisAligner, name);
        }
        if (symmetry.equals("T")) {
            return new JmolSymmetryScriptGeneratorT((RotationAxisAligner)axisAligner, name);
        }
        if (symmetry.equals("O")) {
            return new JmolSymmetryScriptGeneratorO((RotationAxisAligner)axisAligner, name);
        }
        if (symmetry.equals("I")) {
            return new JmolSymmetryScriptGeneratorI((RotationAxisAligner)axisAligner, name);
        }
        if (symmetry.equals("H")) {
            return new JmolSymmetryScriptGeneratorH((HelixAxisAligner)axisAligner, name);
        }
        return null;
    }

    public abstract int getZoom();

    public abstract String getDefaultOrientation();

    public abstract int getOrientationCount();

    public abstract String getOrientation(int var1);

    public String getInstantaneousOrientation(int index) {
        String s = this.getOrientation(index);
        return s.replaceAll("moveto 4", "moveto 0");
    }

    public abstract String getOrientationWithZoom(int var1);

    public abstract String getOrientationName(int var1);

    public abstract Matrix4d getTransformation();

    public abstract void setDefaultColoring(String var1);

    public abstract void setOnTheFly(boolean var1);

    public abstract String drawPolyhedron();

    public abstract String hidePolyhedron();

    public abstract String showPolyhedron();

    public abstract String drawAxes();

    public abstract String hideAxes();

    public abstract String showAxes();

    public abstract String playOrientations();

    public abstract String colorBySubunit();

    public abstract String colorBySequenceCluster();

    public abstract String colorBySymmetry();

    protected static String getJmolColorScript(Map<Color4f, List<String>> map) {
        StringBuilder s = new StringBuilder();
        s.append("color cartoons none;");
        for (Map.Entry<Color4f, List<String>> entry : map.entrySet()) {
            s.append("color{");
            List<String> ids = entry.getValue();
            for (int i = 0; i < ids.size(); ++i) {
                s.append(":");
                s.append(ids.get(i));
                if (i >= ids.size() - 1) continue;
                s.append("|");
            }
            s.append("}");
            s.append(JmolSymmetryScriptGenerator.getJmolColor(entry.getKey()));
            s.append(";");
        }
        return s.toString();
    }

    protected static String getJmolColor(Color4f color) {
        String hex = Integer.toHexString(color.get().getRGB() & 0xFFFFFF | 0x1000000).substring(1);
        return " [x" + hex + "]";
    }

    protected static String getJmolPoint(Tuple3d point) {
        StringBuilder s = new StringBuilder();
        s.append("{");
        s.append(JmolSymmetryScriptGenerator.fDot2(point.x));
        s.append(",");
        s.append(JmolSymmetryScriptGenerator.fDot2(point.y));
        s.append(",");
        s.append(JmolSymmetryScriptGenerator.fDot2(point.z));
        s.append("}");
        return s.toString();
    }

    protected static String f1Dot2(float number) {
        return String.format(Locale.US, "%1.2f", Float.valueOf(number));
    }

    protected static String fDot2(double number) {
        return String.format(Locale.US, "%.2f", number);
    }

    protected static float jMolFloat(double f) {
        return (float)f;
    }

    protected static String getJmolLigandScript() {
        return "select ligand;wireframe 0.16;spacefill 23%;color cpk;";
    }
}

