/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.webstart;

import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignmentFactory;
import org.biojava.nbio.structure.align.client.PdbPair;
import org.biojava.nbio.structure.align.gui.AlignmentGui;
import org.biojava.nbio.structure.align.gui.ChooseDirAction;
import org.biojava.nbio.structure.align.gui.DisplayAFP;
import org.biojava.nbio.structure.align.gui.StructureAlignmentDisplay;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.seq.SmithWaterman3Daligner;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.AligUIManager;

public class WebStartMain {
    private static UserConfiguration userConfig;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        AligUIManager.setLookAndFeel();
        if (args.length == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlignmentGui.getInstance();
                }
            });
            return;
        }
        if (args.length < 3) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlignmentGui.getInstance();
                }
            });
            return;
        }
        String arg0 = args[0];
        if (!(arg0.equals("fatcat") || arg0.equals("biojava") || arg0.equals("fatcat_flexible") || arg0.equals("ce") || arg0.equals("ce_cp") || arg0.equals("sw"))) {
            JOptionPane.showMessageDialog(null, "Wrong arguments. First argument has to be \"fatcat\", \"ce\", \"ce_cp\", \"sw\", \"fatcat_flexible\", or \"biojava\", but got " + arg0);
            return;
        }
        try {
            String name1 = args[1];
            String name2 = args[2];
            PdbPair pair = new PdbPair(name1, name2);
            System.out.println("### user provided: " + pair);
            UserConfiguration config = WebStartMain.getWebStartConfig();
            System.setProperty("PDB_DIR", config.getPdbFilePath());
            System.out.println("using PDB file path: " + config.getPdbFilePath());
            AtomCache cache = new AtomCache(config);
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(3);
            WebStartMain.showProgressBar(frame, "Loading PDB files...", "Loading files from local directory or via FTP.");
            Atom[] ca1 = cache.getAtoms(pair.getName1());
            Atom[] ca2 = cache.getAtoms(pair.getName2());
            frame.dispose();
            System.out.println("done reading structures");
            if (arg0.equalsIgnoreCase("ce") || arg0.equalsIgnoreCase("ce_cp") || arg0.equalsIgnoreCase("sw") || arg0.equalsIgnoreCase("fatcat") || arg0.equalsIgnoreCase("fatcat_flexible")) {
                try {
                    Object algorithm = arg0.equalsIgnoreCase("ce") ? StructureAlignmentFactory.getAlgorithm((String)"jCE") : (arg0.equalsIgnoreCase("ce_cp") ? StructureAlignmentFactory.getAlgorithm((String)"jCE Circular Permutation") : (arg0.equalsIgnoreCase("fatcat") ? StructureAlignmentFactory.getAlgorithm((String)"jFatCat_rigid") : (arg0.equalsIgnoreCase("fatcat_flexible") ? StructureAlignmentFactory.getAlgorithm((String)"jFatCat_flexible") : new SmithWaterman3Daligner())));
                    WebStartMain.showStructureAlignment(algorithm, ca1, ca2, pair.getName1(), pair.getName2());
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Something went wrong! : " + e.getMessage());
                }
                return;
            }
            if (!arg0.equalsIgnoreCase("biojava")) return;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
            System.exit(0);
            return;
        }
    }

    private static JProgressBar showProgressBar(JFrame frame, String title, String displayTxt) {
        frame.setTitle(title);
        JPanel content = new JPanel();
        content.setOpaque(true);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setToolTipText(title);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        progressBar.setIndeterminate(true);
        JTextField txt = new JTextField(displayTxt);
        txt.setEditable(false);
        content.add(txt);
        content.add(progressBar);
        frame.getContentPane().add(content);
        frame.pack();
        frame.setVisible(true);
        return progressBar;
    }

    public static UserConfiguration getWebStartConfig() {
        if (userConfig == null) {
            userConfig = WebStartMain.getDefaultConfig();
        }
        return userConfig;
    }

    public static UserConfiguration getDefaultConfig() {
        userConfig = new UserConfiguration();
        String pdbDir = System.getProperty("PDB_DIR");
        if (pdbDir != null) {
            userConfig.setPdbFilePath(pdbDir);
        }
        return userConfig;
    }

    public static UserConfiguration requestUserConfig() {
        if (userConfig == null) {
            userConfig = new UserConfiguration();
            String pdbDir = System.getProperty("PDB_DIR");
            if (pdbDir != null) {
                userConfig.setPdbFilePath(pdbDir);
                return userConfig;
            }
        }
        JTextField textField = new JTextField();
        ChooseDirAction action = new ChooseDirAction(textField, userConfig);
        action.actionPerformed(null);
        if (textField.getText() == null) {
            String property = "java.io.tmpdir";
            String lineSplit = System.getProperty("file.separator");
            Object tempdir = System.getProperty(property);
            if (!((String)tempdir).endsWith(lineSplit)) {
                tempdir = (String)tempdir + lineSplit;
            }
            userConfig.setPdbFilePath((String)tempdir);
            return userConfig;
        }
        File file = new File(textField.getText());
        if (!file.isDirectory()) {
            System.err.println("did not provide directory, going on level higher! " + file.getAbsolutePath());
            file = file.getParentFile();
        }
        System.setProperty("PDB_DIR", file.getAbsolutePath());
        userConfig.setPdbFilePath(file.getAbsolutePath());
        return userConfig;
    }

    private static void showStructureAlignment(StructureAlignment algorithm, Atom[] ca1, Atom[] ca2, String name1, String name2) throws StructureException {
        JFrame tmpFrame = new JFrame();
        tmpFrame.setDefaultCloseOperation(3);
        String title = "Calculating " + algorithm.getAlgorithmName() + " V." + algorithm.getVersion() + " alignment... ";
        WebStartMain.showProgressBar(tmpFrame, title, "Calculating the structure alignment.");
        AFPChain afpChain = algorithm.align(ca1, ca2);
        afpChain.setName1(name1);
        afpChain.setName2(name2);
        tmpFrame.dispose();
        StructureAlignmentJmol jmol = StructureAlignmentDisplay.display(afpChain, ca1, ca2);
        System.out.println(afpChain.toCE(ca1, ca2));
        DisplayAFP.showAlignmentPanel(afpChain, ca1, ca2, jmol);
    }
}

