/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import org.biojava.nbio.structure.PassthroughIdentifier;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.align.ce.AbstractUserArgumentProcessor;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.gui.AlignmentCalculationRunnable;
import org.biojava.nbio.structure.align.gui.MenuCreator;
import org.biojava.nbio.structure.align.gui.ParameterGUI;
import org.biojava.nbio.structure.align.gui.SelectPDBPanel;
import org.biojava.nbio.structure.align.util.ResourceManager;
import org.biojava.nbio.structure.align.webstart.AligUIManager;
import org.biojava.nbio.structure.gui.util.PDBUploadPanel;
import org.biojava.nbio.structure.gui.util.ScopSelectPanel;
import org.biojava.nbio.structure.symmetry.gui.ProgressThreadDrawer;
import org.biojava.nbio.structure.symmetry.gui.SymmetryCalc;
import org.biojava.nbio.structure.symmetry.internal.CESymmParameters;

public class SymmetryGui
extends JFrame {
    private static final long serialVersionUID = 0L;
    private CESymmParameters params = new CESymmParameters();
    private JButton abortB;
    private SelectPDBPanel tab1;
    private PDBUploadPanel tab2;
    private ScopSelectPanel tab3;
    private Thread thread = null;
    private AlignmentCalculationRunnable alicalc;
    private JTabbedPane masterPane;
    private JTabbedPane tabPane;
    private JProgressBar progress;
    static final ResourceManager resourceManager = ResourceManager.getResourceManager((String)"ce");
    private static final String MAIN_TITLE = "Symmetry Analysis Tool: CE-Symm - V.1.0";
    private static final SymmetryGui me = new SymmetryGui();

    public static void main(String[] args) {
        SymmetryGui.getInstance();
    }

    public static SymmetryGui getInstance() {
        AbstractUserArgumentProcessor.printAboutMe();
        AligUIManager.setLookAndFeel();
        if (!me.isVisible()) {
            me.setVisible(true);
        }
        if (!me.isActive()) {
            me.requestFocus();
        }
        return me;
    }

    public static SymmetryGui getInstanceNoVisibilityChange() {
        return me;
    }

    private SymmetryGui() {
        JMenuBar menu = MenuCreator.initAlignmentGUIMenu(this);
        this.setJMenuBar(menu);
        this.setDefaultCloseOperation(3);
        this.setTitle(MAIN_TITLE);
        this.tab1 = new SelectPDBPanel(false);
        this.tab2 = new PDBUploadPanel(false);
        this.tab3 = new ScopSelectPanel(false);
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Select PDB ID", null, this.tab1, "Select PDB ID to analyze");
        this.tabPane.addTab("Domain", null, this.tab3, "Select domain to analyze.");
        this.tabPane.addTab("Custom file", null, this.tab2, "Analyze your own file.");
        Box hBoxAlgo = this.setupAlgorithm();
        Box vBox = Box.createVerticalBox();
        vBox.add(this.tabPane);
        vBox.add(Box.createGlue());
        this.masterPane = new JTabbedPane();
        this.masterPane.addTab("Symmetry Analysis", vBox);
        Box vBoxMain = Box.createVerticalBox();
        vBoxMain.add(hBoxAlgo);
        vBoxMain.add(this.masterPane);
        vBoxMain.add(this.initButtons());
        this.getContentPane().add(vBoxMain);
        this.pack();
        this.setVisible(true);
    }

    private Box setupAlgorithm() {
        String[] algorithms = new String[]{"JCE-symmetry"};
        JLabel algoLabel = new JLabel("Symmetry algorithm: ");
        JComboBox<String> algorithmList = new JComboBox<String>(algorithms);
        algorithmList.setSelectedIndex(0);
        AbstractAction paramAction = new AbstractAction("Parameters"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymmetryGui.this.configureParameters();
            }
        };
        JButton parameterButton = new JButton(paramAction);
        Box hBoxAlgo = Box.createHorizontalBox();
        hBoxAlgo.add(Box.createGlue());
        hBoxAlgo.add(algoLabel);
        hBoxAlgo.add(algorithmList);
        hBoxAlgo.add(Box.createGlue());
        hBoxAlgo.add(parameterButton);
        hBoxAlgo.add(Box.createGlue());
        return hBoxAlgo;
    }

    private Box initButtons() {
        this.progress = new JProgressBar();
        this.progress.setIndeterminate(false);
        this.progress.setMaximumSize(new Dimension(10, 100));
        this.progress.setVisible(false);
        AbstractAction action1 = new AbstractAction("Analyze"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                int selectedIndex = SymmetryGui.this.masterPane.getSelectedIndex();
                if (selectedIndex == 0) {
                    SymmetryGui.this.calcAlignment();
                } else {
                    System.err.println("Unknown TAB: " + selectedIndex);
                }
            }
        };
        JButton submitB = new JButton(action1);
        AbstractAction action3 = new AbstractAction("Abort"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymmetryGui.this.abortCalc();
            }
        };
        this.abortB = new JButton(action3);
        this.abortB.setEnabled(false);
        AbstractAction action2 = new AbstractAction("Exit"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymmetryGui.this.abortCalc();
                SymmetryGui.this.dispose();
                System.exit(0);
            }
        };
        JButton closeB = new JButton(action2);
        Box hBox = Box.createHorizontalBox();
        hBox.add(closeB);
        hBox.add(Box.createGlue());
        hBox.add(this.progress);
        hBox.add(this.abortB);
        hBox.add(submitB);
        return hBox;
    }

    protected void configureParameters() {
        System.out.println("configure parameters for jCE-symm");
        new ParameterGUI((ConfigStrucAligParams)this.params, "jCE-symm");
    }

    public void cleanUp() {
        if (this.alicalc != null) {
            this.alicalc.cleanup();
        }
    }

    private void calcAlignment() {
        int pos = this.tabPane.getSelectedIndex();
        JPanel tab = null;
        if (pos == 0) {
            tab = this.tab1;
        } else if (pos == 1) {
            tab = this.tab3;
        } else if (pos == 2) {
            tab = this.tab2;
        }
        try {
            Structure s = tab.getStructure1();
            if (s == null) {
                System.err.println("Please select structure");
                return;
            }
            PassthroughIdentifier name = new PassthroughIdentifier("custom");
            name = pos == 0 ? this.tab1.getName1() : s.getStructureIdentifier();
            System.out.println("Analyzing: " + (StructureIdentifier)name);
            this.alicalc = new SymmetryCalc(this, s);
            this.thread = new Thread(this.alicalc);
            this.thread.start();
            this.abortB.setEnabled(true);
            this.progress.setIndeterminate(true);
            ProgressThreadDrawer drawer = new ProgressThreadDrawer(this.progress);
            drawer.start();
        }
        catch (StructureException e) {
            JOptionPane.showMessageDialog(null, "Could not align structures. Exception: " + e.getMessage());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not align structures. Exception: " + e.getMessage());
        }
    }

    public void notifyCalcFinished() {
        this.abortB.setEnabled(false);
        this.thread = null;
        this.progress.setIndeterminate(false);
        this.repaint();
    }

    private void abortCalc() {
        System.err.println("Interrupting alignment ...");
        if (this.alicalc != null) {
            this.alicalc.interrupt();
        }
        this.notifyCalcFinished();
    }

    public CESymmParameters getParameters() {
        return this.params;
    }
}

