/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignmentFactory;
import org.biojava.nbio.structure.align.ce.AbstractUserArgumentProcessor;
import org.biojava.nbio.structure.align.gui.AlignmentCalc;
import org.biojava.nbio.structure.align.gui.AlignmentCalculationRunnable;
import org.biojava.nbio.structure.align.gui.MenuCreator;
import org.biojava.nbio.structure.align.gui.ParameterGUI;
import org.biojava.nbio.structure.align.gui.ProgressThreadDrawer;
import org.biojava.nbio.structure.align.gui.SelectPDBPanel;
import org.biojava.nbio.structure.align.util.ResourceManager;
import org.biojava.nbio.structure.align.webstart.AligUIManager;
import org.biojava.nbio.structure.gui.util.PDBUploadPanel;
import org.biojava.nbio.structure.gui.util.ScopSelectPanel;

public class AlignmentGui
extends JFrame {
    private static final long serialVersionUID = 0L;
    StructureAlignment algorithm;
    JButton abortB;
    SelectPDBPanel tab1;
    PDBUploadPanel tab2;
    ScopSelectPanel tab3;
    Thread thread = null;
    AlignmentCalculationRunnable alicalc;
    JTabbedPane masterPane;
    JTabbedPane tabPane;
    JProgressBar progress;
    static final ResourceManager resourceManager = ResourceManager.getResourceManager((String)"ce");
    private static final String MAIN_TITLE = "Pairwise Structure Alignment - Main - V." + resourceManager.getString("ce.version");
    private static final AlignmentGui me = new AlignmentGui();

    public static void main(String[] args) {
        AlignmentGui.getInstance();
    }

    public static AlignmentGui getInstance() {
        AbstractUserArgumentProcessor.printAboutMe();
        AligUIManager.setLookAndFeel();
        if (!me.isVisible()) {
            me.setVisible(true);
        }
        if (!me.isActive()) {
            me.requestFocus();
        }
        return me;
    }

    public static AlignmentGui getInstanceNoVisibilityChange() {
        return me;
    }

    protected AlignmentGui() {
        JMenuBar menu = MenuCreator.initAlignmentGUIMenu(this);
        this.setJMenuBar(menu);
        this.setDefaultCloseOperation(3);
        this.setTitle(MAIN_TITLE);
        this.tab1 = new SelectPDBPanel();
        this.tab2 = new PDBUploadPanel();
        this.tab3 = new ScopSelectPanel();
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Select PDB ID", null, this.tab1, "Select PDB ID to align");
        this.tabPane.addTab("Domains", null, this.tab3, "Select domains to align.");
        this.tabPane.addTab("Custom files", null, this.tab2, "Align your own files.");
        Box hBoxAlgo = this.setupAlgorithm();
        Box vBox = Box.createVerticalBox();
        vBox.add(this.tabPane);
        vBox.add(Box.createGlue());
        this.masterPane = new JTabbedPane();
        this.masterPane.addTab("Pairwise Comparison", vBox);
        Box vBoxMain = Box.createVerticalBox();
        vBoxMain.add(hBoxAlgo);
        vBoxMain.add(this.masterPane);
        vBoxMain.add(this.initButtons());
        this.getContentPane().add(vBoxMain);
        this.pack();
        this.setVisible(true);
    }

    private Box setupAlgorithm() {
        String[] algorithms = StructureAlignmentFactory.getAllAlgorithmNames();
        try {
            this.algorithm = StructureAlignmentFactory.getAlgorithm((String)algorithms[0]);
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
        JLabel algoLabel = new JLabel("Select alignment algorithm: ");
        JComboBox<String> algorithmList = new JComboBox<String>(algorithms);
        algorithmList.setSelectedIndex(0);
        AbstractAction actionAlgorithm = new AbstractAction("Algorithm"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                JComboBox cb = (JComboBox)evt.getSource();
                String algorithmName = (String)cb.getSelectedItem();
                AlignmentGui.this.updateAlgorithm(algorithmName);
            }
        };
        algorithmList.addActionListener(actionAlgorithm);
        AbstractAction paramAction = new AbstractAction("Parameters"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentGui.this.configureParameters();
            }
        };
        JButton parameterButton = new JButton(paramAction);
        Box hBoxAlgo = Box.createHorizontalBox();
        hBoxAlgo.add(Box.createGlue());
        hBoxAlgo.add(algoLabel);
        hBoxAlgo.add(algorithmList);
        hBoxAlgo.add(Box.createGlue());
        hBoxAlgo.add(parameterButton);
        hBoxAlgo.add(Box.createGlue());
        return hBoxAlgo;
    }

    private Box initButtons() {
        this.progress = new JProgressBar();
        this.progress.setIndeterminate(false);
        this.progress.setMaximumSize(new Dimension(10, 100));
        this.progress.setVisible(false);
        AbstractAction action1 = new AbstractAction("Align"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                int selectedIndex = AlignmentGui.this.masterPane.getSelectedIndex();
                if (selectedIndex == 0) {
                    AlignmentGui.this.calcAlignment();
                } else {
                    System.err.println("Unknown TAB: " + selectedIndex);
                }
            }
        };
        JButton submitB = new JButton(action1);
        AbstractAction action3 = new AbstractAction("Abort"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentGui.this.abortCalc();
            }
        };
        this.abortB = new JButton(action3);
        this.abortB.setEnabled(false);
        AbstractAction action2 = new AbstractAction("Exit"){
            public static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentGui.this.abortCalc();
                AlignmentGui.this.dispose();
                System.exit(0);
            }
        };
        JButton closeB = new JButton(action2);
        Box hBox = Box.createHorizontalBox();
        hBox.add(closeB);
        hBox.add(Box.createGlue());
        hBox.add(this.progress);
        hBox.add(this.abortB);
        hBox.add(submitB);
        return hBox;
    }

    protected void configureParameters() {
        StructureAlignment algorithm = this.getStructureAlignment();
        System.out.println("configure parameters for " + algorithm.getAlgorithmName());
        new ParameterGUI(algorithm.getParameters(), algorithm.getAlgorithmName());
    }

    public void cleanUp() {
        if (this.alicalc != null) {
            this.alicalc.cleanup();
        }
    }

    private void calcAlignment() {
        int pos = this.tabPane.getSelectedIndex();
        JPanel tab = null;
        if (pos == 0) {
            tab = this.tab1;
        } else if (pos == 1) {
            tab = this.tab3;
        } else if (pos == 2) {
            tab = this.tab2;
        }
        try {
            Structure s1 = tab.getStructure1();
            Structure s2 = tab.getStructure2();
            if (s1 == null) {
                System.err.println("please select structure 1");
                return;
            }
            if (s2 == null) {
                System.err.println("please select structure 2");
                return;
            }
            String name1 = "custom1";
            String name2 = "custom2";
            if (pos == 0) {
                name1 = this.tab1.getName1().getIdentifier();
                name2 = this.tab1.getName2().getIdentifier();
            } else {
                name1 = s1.getName();
                name2 = s2.getName();
            }
            System.out.println("aligning: " + name1 + " " + name2);
            this.alicalc = new AlignmentCalc(this, s1, s2, name1, name2);
            this.thread = new Thread(this.alicalc);
            this.thread.start();
            this.abortB.setEnabled(true);
            this.progress.setIndeterminate(true);
            ProgressThreadDrawer drawer = new ProgressThreadDrawer(this.progress);
            drawer.start();
        }
        catch (StructureException e) {
            JOptionPane.showMessageDialog(null, "Could not align structures. Exception: " + e.getMessage());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not align structures. Exception: " + e.getMessage());
        }
    }

    public void notifyCalcFinished() {
        this.abortB.setEnabled(false);
        this.thread = null;
        this.progress.setIndeterminate(false);
        this.repaint();
    }

    private void abortCalc() {
        System.err.println("Interrupting alignment ...");
        if (this.alicalc != null) {
            this.alicalc.interrupt();
        }
        this.notifyCalcFinished();
    }

    public StructureAlignment getStructureAlignment() {
        return this.algorithm;
    }

    private void updateAlgorithm(String algorithmName) {
        try {
            this.algorithm = StructureAlignmentFactory.getAlgorithm((String)algorithmName);
        }
        catch (StructureException ex) {
            ex.printStackTrace();
        }
    }
}

