/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.jmolScript;

import org.biojava.nbio.structure.symmetry.axis.RotationAxisAligner;
import org.biojava.nbio.structure.symmetry.geometry.Polyhedron;
import org.biojava.nbio.structure.symmetry.geometry.Prism;
import org.biojava.nbio.structure.symmetry.geometry.RectangularPrism;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGeneratorPointGroup;

public class JmolSymmetryScriptGeneratorCn
extends JmolSymmetryScriptGeneratorPointGroup {
    public JmolSymmetryScriptGeneratorCn(RotationAxisAligner axisTransformation, String name) {
        super(axisTransformation, name);
        if ("C2".equals(axisTransformation.getRotationGroup().getPointGroup())) {
            this.setPolyhedron((Polyhedron)new RectangularPrism(axisTransformation.getDimension().z * 2.0, axisTransformation.getDimension().x * 2.0, axisTransformation.getDimension().y * 2.0));
        } else {
            Prism p = new Prism(axisTransformation.getRotationGroup().getRotation(0).getFold());
            p.setHeight(axisTransformation.getDimension().z * 2.0);
            p.setInscribedRadius(axisTransformation.getRadius());
            this.setPolyhedron((Polyhedron)p);
        }
    }

    @Override
    public int getZoom() {
        double maxExtension = this.getMaxExtension();
        RotationAxisAligner at = this.getAxisTransformation();
        double polyhedronExtension = Math.max(this.getPolyhedron().getCirumscribedRadius(), at.getDimension().z);
        int zoom = Math.round((float)(maxExtension / polyhedronExtension * 110.0));
        if (zoom > 100) {
            zoom = 100;
        }
        return zoom;
    }

    @Override
    public int getOrientationCount() {
        if ("C2".equals(this.getAxisTransformation().getRotationGroup().getPointGroup())) {
            return this.getPolyhedron().getViewCount() - 2;
        }
        return this.getPolyhedron().getViewCount();
    }

    @Override
    public String getOrientationName(int index) {
        if ("C2".equals(this.getAxisTransformation().getRotationGroup().getPointGroup())) {
            if (index == 0) {
                return "Front C2 axis";
            }
            if (index == 2) {
                return "Back C2 axis";
            }
        }
        return this.getPolyhedron().getViewName(index);
    }
}

