/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.client;

import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.client.StructureName;

public class PdbPair
implements Comparable<PdbPair> {
    StructureName name1;
    StructureName name2;

    public PdbPair(String name1, String name2) {
        this(new StructureName(name1), new StructureName(name2));
    }

    public PdbPair(StructureName name1, StructureName name2) {
        this.name1 = name1;
        this.name2 = name2;
    }

    public String getName1() {
        return this.name1.getIdentifier();
    }

    public void setName1(String name1) {
        this.name1 = new StructureName(name1);
    }

    public String getName2() {
        return this.name2.getIdentifier();
    }

    public void setName2(String name2) {
        this.name2 = new StructureName(name2);
    }

    public String toString() {
        return "PdbPair [name1=" + this.name1 + ", name2=" + this.name2 + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name1 == null ? 0 : this.name1.hashCode());
        result = 31 * result + (this.name2 == null ? 0 : this.name2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdbPair other = (PdbPair)obj;
        if (this.name1 == null ? other.name1 != null : !this.name1.equals(other.name1)) {
            return false;
        }
        return !(this.name2 == null ? other.name2 != null : !this.name2.equals(other.name2));
    }

    @Override
    public int compareTo(PdbPair o) {
        if (this.equals(o)) {
            return 0;
        }
        int c = this.name1.compareTo(o.name1);
        if (c != 0) {
            return c;
        }
        return this.name2.compareTo(o.name2);
    }

    public String getPDBCode1() throws StructureException {
        return this.name1.getPdbId();
    }

    public String getPDBCode2() throws StructureException {
        return this.name2.getPdbId();
    }

    public String getChainId1() {
        return this.name1.getChainId();
    }

    public String getChainId2() {
        return this.name2.getChainId();
    }

    public PdbPair getReverse() {
        PdbPair newPair = new PdbPair(this.name2, this.name1);
        return newPair;
    }
}

