/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmtf;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.BondImpl;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.EntityType;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.HetatomImpl;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;
import org.biojava.nbio.structure.io.mmcif.chem.ResidueType;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmtf.MmtfUtils;
import org.biojava.nbio.structure.quaternary.BioAssemblyInfo;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.xtal.CrystalCell;
import org.biojava.nbio.structure.xtal.SpaceGroup;
import org.rcsb.mmtf.api.StructureAdapterInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MmtfStructureReader
implements StructureAdapterInterface,
Serializable {
    private static final long serialVersionUID = 6772030485225130853L;
    private static final Logger logger = LoggerFactory.getLogger(MmtfStructureReader.class);
    private Structure structure = new StructureImpl();
    private int modelNumber = 0;
    private Chain chain;
    private Group group;
    private List<Atom> atomsInGroup;
    private Atom[] allAtoms;
    private int atomCounter;
    private List<EntityInfo> entityInfoList = new ArrayList<EntityInfo>();
    private List<Chain> chainList = new ArrayList<Chain>();
    private List<Map<String, Chain>> chainMap = new ArrayList<Map<String, Chain>>();
    private List<double[]> transformList = new ArrayList<double[]>();
    private int bioassIndex;
    private Map<String, String> chainSequenceMap = new HashMap<String, String>();

    public Structure getStructure() {
        return this.structure;
    }

    public void finalizeStructure() {
        int counter = 0;
        for (EntityInfo entityInfo : this.entityInfoList) {
            entityInfo.setMolId(++counter);
        }
        this.structure.setEntityInfos(this.entityInfoList);
        for (int i = 0; i < this.chainMap.size(); ++i) {
            Map<String, Chain> modelChainMap = this.chainMap.get(i);
            for (Chain modelChain : modelChainMap.values()) {
                this.structure.addChain(modelChain, i);
                String sequence = this.chainSequenceMap.get(modelChain.getId());
                if (sequence == null) {
                    logger.warn("Sequence is null for chain with asym_id {}. Most likely the chain is non-polymeric. Will not add seqres groups for it.", (Object)modelChain.getId());
                    continue;
                }
                MmtfUtils.addSeqRes(modelChain, sequence);
            }
        }
        StructureTools.cleanUpAltLocs(this.structure);
    }

    public void initStructure(int totalNumBonds, int totalNumAtoms, int totalNumGroups, int totalNumChains, int totalNumModels, String modelId) {
        this.structure.setPDBCode(modelId);
        this.allAtoms = new Atom[totalNumAtoms];
    }

    public void setModelInfo(int inputModelNumber, int chainCount) {
        this.modelNumber = inputModelNumber;
        this.structure.addModel(new ArrayList<Chain>(chainCount));
        this.chainMap.add(new HashMap());
    }

    public void setChainInfo(String chainId, String chainName, int groupCount) {
        Map<String, Chain> modelChainMap = this.chainMap.get(this.modelNumber);
        if (modelChainMap.containsKey(chainId)) {
            this.chain = modelChainMap.get(chainId);
        } else {
            this.chain = new ChainImpl();
            this.chain.setId(chainId.trim());
            this.chain.setName(chainName);
            this.chain.setAtomGroups(new ArrayList<Group>(groupCount));
            modelChainMap.put(chainId, this.chain);
            this.chainList.add(this.chain);
        }
    }

    public void setGroupInfo(String groupName, int groupNumber, char insertionCode, String chemCompType, int atomCount, int bondCount, char singleLetterCode, int sequenceIndexId, int secStructType) {
        ResidueType residueType = ResidueType.getResidueTypeFromString(chemCompType);
        int polymerType = this.getGroupTypIndicator(residueType.polymerType);
        switch (polymerType) {
            case 1: {
                AminoAcidImpl aa = new AminoAcidImpl();
                aa.setAminoType(Character.valueOf(singleLetterCode));
                this.group = aa;
                break;
            }
            case 2: {
                this.group = new NucleotideImpl();
                break;
            }
            default: {
                this.group = new HetatomImpl();
            }
        }
        this.atomsInGroup = new ArrayList<Atom>();
        ChemComp chemComp = new ChemComp();
        chemComp.setOne_letter_code(String.valueOf(singleLetterCode));
        chemComp.setType(chemCompType.toUpperCase());
        chemComp.setResidueType(residueType);
        chemComp.setPolymerType(residueType.polymerType);
        this.group.setChemComp(chemComp);
        this.group.setPDBName(groupName);
        if (insertionCode == '\u0000') {
            this.group.setResidueNumber(this.chain.getName().trim(), groupNumber, null);
        } else {
            this.group.setResidueNumber(this.chain.getName().trim(), groupNumber, Character.valueOf(insertionCode));
        }
        this.group.setAtoms(new ArrayList<Atom>(atomCount));
        if (polymerType == 1 || polymerType == 2) {
            MmtfUtils.insertSeqResGroup(this.chain, this.group, sequenceIndexId);
        }
        if (atomCount > 0) {
            this.chain.addGroup(this.group);
        }
        MmtfUtils.setSecStructType(this.group, secStructType);
    }

    private Group getGroupWithSameResNumButDiffPDBName() {
        for (Group g : this.chain.getAtomGroups()) {
            if (!g.getResidueNumber().equals(this.group.getResidueNumber()) || g.getPDBName().equals(this.group.getPDBName())) continue;
            return g;
        }
        return null;
    }

    public void setAtomInfo(String atomName, int serialNumber, char alternativeLocationId, float x, float y, float z, float occupancy, float temperatureFactor, String element, int charge) {
        AtomImpl atom = new AtomImpl();
        Group altGroup = null;
        atom.setPDBserial(serialNumber);
        atom.setName(atomName.trim());
        atom.setElement(Element.valueOfIgnoreCase(element));
        if (alternativeLocationId == '\u0000') {
            alternativeLocationId = (char)32;
        }
        if (alternativeLocationId != ' ') {
            altGroup = this.getCorrectAltLocGroup(Character.valueOf(alternativeLocationId));
            atom.setAltLoc(Character.valueOf(alternativeLocationId));
        } else {
            atom.setAltLoc(Character.valueOf(' '));
        }
        atom.setX(x);
        atom.setY(y);
        atom.setZ(z);
        atom.setOccupancy(occupancy);
        atom.setTempFactor(temperatureFactor);
        atom.setCharge((short)charge);
        if (altGroup == null) {
            this.group.addAtom(atom);
        } else {
            altGroup.setChain(this.chain);
            altGroup.addAtom(atom);
        }
        if (!this.group.hasAtom(atom.getName()) && this.group.getPDBName().equals(atom.getGroup().getPDBName()) && !StructureTools.hasNonDeuteratedEquiv(atom, this.group)) {
            this.group.addAtom(atom);
        }
        this.atomsInGroup.add(atom);
        this.allAtoms[this.atomCounter] = atom;
        ++this.atomCounter;
    }

    public void setGroupBond(int indOne, int indTwo, int bondOrder) {
        Atom atomOne = this.atomsInGroup.get(indOne);
        Atom atomTwo = this.atomsInGroup.get(indTwo);
        BondImpl bond = new BondImpl(atomOne, atomTwo, bondOrder);
    }

    public void setInterGroupBond(int indOne, int indTwo, int bondOrder) {
        Atom atomOne = this.allAtoms[indOne];
        Atom atomTwo = this.allAtoms[indTwo];
        BondImpl bond = new BondImpl(atomOne, atomTwo, bondOrder);
    }

    private Group getCorrectAltLocGroup(Character altLoc) {
        Atom a1;
        List<Atom> atoms = this.group.getAtoms();
        if (atoms.size() > 0 && (a1 = atoms.get(0)).getAltLoc().equals(altLoc)) {
            return this.group;
        }
        Group altLocgroup = this.group.getAltLocGroup(altLoc);
        if (altLocgroup != null) {
            return altLocgroup;
        }
        Group oldGroup = this.getGroupWithSameResNumButDiffPDBName();
        if (oldGroup != null) {
            Group altLocG = this.group;
            this.group = oldGroup;
            this.group.addAltLoc(altLocG);
            this.chain.getAtomGroups().remove(altLocG);
            return altLocG;
        }
        if (this.group.getAtoms().size() == 0) {
            return this.group;
        }
        Group altLocG = (Group)this.group.clone();
        altLocG.setAtoms(new ArrayList<Atom>());
        altLocG.getAltLocs().clear();
        this.group.addAltLoc(altLocG);
        return altLocG;
    }

    public void setXtalInfo(String spaceGroupString, float[] unitCell, double[][] ncsOperMatrixList) {
        PDBCrystallographicInfo pci = new PDBCrystallographicInfo();
        SpaceGroup spaceGroup = SpaceGroup.parseSpaceGroup(spaceGroupString);
        pci.setSpaceGroup(spaceGroup);
        if (unitCell.length > 0) {
            CrystalCell cell = new CrystalCell(unitCell[0], unitCell[1], unitCell[2], unitCell[3], unitCell[4], unitCell[5]);
            pci.setCrystalCell(cell);
            this.structure.setCrystallographicInfo(pci);
        }
        pci.setNcsOperators(MmtfUtils.getNcsAsMatrix4d(ncsOperMatrixList));
    }

    private int getGroupTypIndicator(PolymerType polymerType) {
        if (PolymerType.PROTEIN_ONLY.contains(polymerType)) {
            return 1;
        }
        if (PolymerType.POLYNUCLEOTIDE_ONLY.contains(polymerType)) {
            return 2;
        }
        return 0;
    }

    public void setBioAssemblyTrans(int bioAssemblyId, int[] inputChainIndices, double[] inputTransform, String name) {
        BioAssemblyInfo bioAssInfo;
        PDBHeader pdbHeader;
        Map<Integer, BioAssemblyInfo> bioAssemblies;
        if (this.bioassIndex != ++bioAssemblyId) {
            this.transformList = new ArrayList<double[]>();
            this.bioassIndex = bioAssemblyId;
        }
        if ((bioAssemblies = (pdbHeader = this.structure.getPDBHeader()).getBioAssemblies()).containsKey(bioAssemblyId)) {
            bioAssInfo = bioAssemblies.get(bioAssemblyId);
        } else {
            bioAssInfo = new BioAssemblyInfo();
            bioAssInfo.setTransforms(new ArrayList<BiologicalAssemblyTransformation>());
            bioAssemblies.put(bioAssemblyId, bioAssInfo);
            bioAssInfo.setId(bioAssemblyId);
        }
        for (int currChainIndex : inputChainIndices) {
            BiologicalAssemblyTransformation bioAssTrans = new BiologicalAssemblyTransformation();
            Integer transId = this.transformList.indexOf(inputTransform) + 1;
            if (transId == 0) {
                this.transformList.add(inputTransform);
                transId = this.transformList.indexOf(inputTransform) + 1;
            }
            bioAssTrans.setId(transId.toString());
            if (currChainIndex == -1) continue;
            bioAssTrans.setChainId(this.chainList.get(currChainIndex).getId());
            Matrix4d mat4d = new Matrix4d(inputTransform);
            bioAssTrans.setTransformationMatrix(mat4d);
            bioAssInfo.getTransforms().add(bioAssTrans);
        }
    }

    public void setEntityInfo(int[] chainIndices, String sequence, String description, String type) {
        EntityInfo entityInfo = new EntityInfo();
        entityInfo.setDescription(description);
        entityInfo.setType(EntityType.entityTypeFromString(type));
        ArrayList<Chain> chains = new ArrayList<Chain>();
        for (int index : chainIndices) {
            chains.add(this.chainList.get(index));
            this.chainList.get(index).setEntityInfo(entityInfo);
            this.chainSequenceMap.put(this.chainList.get(index).getId(), sequence);
        }
        entityInfo.setChains(chains);
        this.entityInfoList.add(entityInfo);
    }

    public void setHeaderInfo(float rFree, float rWork, float resolution, String title, String depositionDate, String releaseDate, String[] experimentalMethods) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        PDBHeader pdbHeader = this.structure.getPDBHeader();
        pdbHeader.setTitle(title);
        pdbHeader.setResolution(resolution);
        pdbHeader.setRfree(rFree);
        pdbHeader.setRwork(rWork);
        if (experimentalMethods != null) {
            for (String techniqueStr : experimentalMethods) {
                pdbHeader.setExperimentalTechnique(techniqueStr);
            }
        }
        if (depositionDate != null) {
            try {
                Date depDate = formatter.parse(depositionDate);
                pdbHeader.setDepDate(depDate);
            }
            catch (ParseException e) {
                logger.warn("Could not parse date string '{}', depositon date will be unavailable", (Object)depositionDate);
            }
        } else {
            pdbHeader.setDepDate(new Date(0L));
        }
        if (releaseDate != null) {
            try {
                Date relDate = formatter.parse(releaseDate);
                pdbHeader.setRelDate(relDate);
            }
            catch (ParseException e) {
                logger.warn("Could not parse date string '{}', release date will be unavailable", (Object)releaseDate);
            }
        } else {
            pdbHeader.setRelDate(new Date(0L));
        }
    }
}

