/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.cif;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collector;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.EntityType;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.cif.CifFileSupplier;
import org.biojava.nbio.structure.xtal.CrystalCell;
import org.biojava.nbio.structure.xtal.SpaceGroup;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.builder.BlockBuilder;
import org.rcsb.cif.model.builder.CategoryBuilder;
import org.rcsb.cif.model.builder.CifBuilder;
import org.rcsb.cif.model.builder.FloatColumnBuilder;
import org.rcsb.cif.model.builder.IntColumnBuilder;
import org.rcsb.cif.model.builder.StrColumnBuilder;

class CifFileSupplierImpl
implements CifFileSupplier<Structure> {
    CifFileSupplierImpl() {
    }

    @Override
    public CifFile get(Structure structure) {
        CrystalCell crystalCell = structure.getPDBHeader().getCrystallographicInfo().getCrystalCell();
        SpaceGroup spaceGroup = structure.getPDBHeader().getCrystallographicInfo().getSpaceGroup();
        List<WrappedAtom> wrappedAtoms = CifFileSupplierImpl.collectWrappedAtoms(structure);
        Category atomSite = wrappedAtoms.stream().collect(CifFileSupplierImpl.toAtomSite());
        BlockBuilder blockBuilder = new CifBuilder().enterBlock(structure.getPDBCode());
        if (atomSite.isDefined() && atomSite.getRowCount() > 0) {
            blockBuilder.addCategory(atomSite);
        }
        if (crystalCell != null) {
            ((CategoryBuilder.CellBuilder)((CategoryBuilder.CellBuilder)((CategoryBuilder.CellBuilder)((CategoryBuilder.CellBuilder)((CategoryBuilder.CellBuilder)((CategoryBuilder.CellBuilder)blockBuilder.enterCell().enterLengthA().add(new double[]{crystalCell.getA()}).leaveColumn()).enterLengthB().add(new double[]{crystalCell.getB()}).leaveColumn()).enterLengthC().add(new double[]{crystalCell.getC()}).leaveColumn()).enterAngleAlpha().add(new double[]{crystalCell.getAlpha()}).leaveColumn()).enterAngleBeta().add(new double[]{crystalCell.getBeta()}).leaveColumn()).enterAngleGamma().add(new double[]{crystalCell.getGamma()}).leaveColumn()).leaveCategory();
        }
        if (spaceGroup != null) {
            ((CategoryBuilder.SymmetryBuilder)blockBuilder.enterSymmetry().enterSpaceGroupNameH_M().add(new String[]{spaceGroup.getShortSymbol()}).leaveColumn()).leaveCategory();
        }
        return blockBuilder.leaveBlock().leaveFile();
    }

    private static List<WrappedAtom> collectWrappedAtoms(Structure structure) {
        ArrayList<WrappedAtom> wrappedAtoms = new ArrayList<WrappedAtom>();
        for (int modelIndex = 0; modelIndex < structure.nrModels(); ++modelIndex) {
            int model = modelIndex + 1;
            for (Chain chain : structure.getChains(modelIndex)) {
                String chainName = chain.getName();
                String chainId = chain.getId();
                for (Group group : chain.getAtomGroups()) {
                    LinkedHashMap<Integer, WrappedAtom> uniqueAtoms = new LinkedHashMap<Integer, WrappedAtom>();
                    for (int atomIndex = 0; atomIndex < group.size(); ++atomIndex) {
                        Atom atom = group.getAtom(atomIndex);
                        if (atom == null) continue;
                        uniqueAtoms.put(atom.getPDBserial(), new WrappedAtom(chain, model, chainName, chainId, atom, atom.getPDBserial()));
                    }
                    if (group.hasAltLoc()) {
                        for (Group alt : group.getAltLocs()) {
                            for (int atomIndex = 0; atomIndex < alt.size(); ++atomIndex) {
                                Atom atom = alt.getAtom(atomIndex);
                                if (atom == null) continue;
                                uniqueAtoms.put(atom.getPDBserial(), new WrappedAtom(chain, model, chainName, chainId, atom, atom.getPDBserial()));
                            }
                        }
                    }
                    wrappedAtoms.addAll(uniqueAtoms.values());
                }
            }
        }
        return wrappedAtoms;
    }

    private static Collector<WrappedAtom, ?, Category> toAtomSite() {
        return Collector.of(AtomSiteCollector::new, AtomSiteCollector::accept, AtomSiteCollector::combine, AtomSiteCollector::get, new Collector.Characteristics[0]);
    }

    static class AtomSiteCollector
    implements Consumer<WrappedAtom> {
        private final CategoryBuilder.AtomSiteBuilder atomSiteBuilder = new CategoryBuilder.AtomSiteBuilder(null);
        private final StrColumnBuilder<CategoryBuilder.AtomSiteBuilder> groupPDB = this.atomSiteBuilder.enterGroupPDB();
        private final IntColumnBuilder<CategoryBuilder.AtomSiteBuilder> id = this.atomSiteBuilder.enterId();
        private final StrColumnBuilder<CategoryBuilder.AtomSiteBuilder> typeSymbol = this.atomSiteBuilder.enterTypeSymbol();
        private final StrColumnBuilder<CategoryBuilder.AtomSiteBuilder> labelAtomId = this.atomSiteBuilder.enterLabelAtomId();
        private final StrColumnBuilder<CategoryBuilder.AtomSiteBuilder> labelAltId = this.atomSiteBuilder.enterLabelAltId();
        private final StrColumnBuilder<CategoryBuilder.AtomSiteBuilder> labelCompId = this.atomSiteBuilder.enterLabelCompId();
        private final StrColumnBuilder<CategoryBuilder.AtomSiteBuilder> labelAsymId = this.atomSiteBuilder.enterLabelAsymId();
        private final StrColumnBuilder<CategoryBuilder.AtomSiteBuilder> labelEntityId = this.atomSiteBuilder.enterLabelEntityId();
        private final IntColumnBuilder<CategoryBuilder.AtomSiteBuilder> labelSeqId = this.atomSiteBuilder.enterLabelSeqId();
        private final StrColumnBuilder<CategoryBuilder.AtomSiteBuilder> pdbxPDBInsCode = this.atomSiteBuilder.enterPdbxPDBInsCode();
        private final FloatColumnBuilder<CategoryBuilder.AtomSiteBuilder> cartnX = this.atomSiteBuilder.enterCartnX();
        private final FloatColumnBuilder<CategoryBuilder.AtomSiteBuilder> cartnY = this.atomSiteBuilder.enterCartnY();
        private final FloatColumnBuilder<CategoryBuilder.AtomSiteBuilder> cartnZ = this.atomSiteBuilder.enterCartnZ();
        private final FloatColumnBuilder<CategoryBuilder.AtomSiteBuilder> occupancy = this.atomSiteBuilder.enterOccupancy();
        private final FloatColumnBuilder<CategoryBuilder.AtomSiteBuilder> bIsoOrEquiv = this.atomSiteBuilder.enterBIsoOrEquiv();
        private final IntColumnBuilder<CategoryBuilder.AtomSiteBuilder> authSeqId = this.atomSiteBuilder.enterAuthSeqId();
        private final StrColumnBuilder<CategoryBuilder.AtomSiteBuilder> authCompId = this.atomSiteBuilder.enterAuthCompId();
        private final StrColumnBuilder<CategoryBuilder.AtomSiteBuilder> authAsymId = this.atomSiteBuilder.enterAuthAsymId();
        private final StrColumnBuilder<CategoryBuilder.AtomSiteBuilder> authAtomId = this.atomSiteBuilder.enterAuthAtomId();
        private final IntColumnBuilder<CategoryBuilder.AtomSiteBuilder> pdbxPDBModelNum = this.atomSiteBuilder.enterPdbxPDBModelNum();

        AtomSiteCollector() {
        }

        @Override
        public void accept(WrappedAtom wrappedAtom) {
            Atom atom = wrappedAtom.getAtom();
            Group group = atom.getGroup();
            Chain chain = group.getChain();
            this.groupPDB.add(new String[]{group.getType().equals((Object)GroupType.HETATM) ? "HETATM" : "ATOM"});
            this.id.add(new int[]{wrappedAtom.getAtomId()});
            Element element = atom.getElement();
            this.typeSymbol.add(new String[]{element.equals((Object)Element.R) ? "X" : element.toString().toUpperCase()});
            this.labelAtomId.add(new String[]{atom.getName()});
            Character altLoc = atom.getAltLoc();
            if (altLoc == null || altLoc.charValue() == ' ') {
                this.labelAltId.markNextNotPresent();
            } else {
                this.labelAltId.add(new String[]{String.valueOf(altLoc)});
            }
            this.labelCompId.add(new String[]{group.getPDBName()});
            this.labelAsymId.add(new String[]{wrappedAtom.getChainId()});
            String entityId = "0";
            int seqId = group.getResidueNumber().getSeqNum();
            if (chain.getEntityInfo() != null) {
                entityId = Integer.toString(chain.getEntityInfo().getMolId());
                if (chain.getEntityInfo().getType() == EntityType.POLYMER) {
                    seqId = chain.getEntityInfo().getAlignedResIndex(group, chain);
                }
            }
            this.labelEntityId.add(new String[]{entityId});
            this.labelSeqId.add(new int[]{seqId});
            String insCode = "";
            if (group.getResidueNumber().getInsCode() != null) {
                insCode = Character.toString(group.getResidueNumber().getInsCode().charValue());
            }
            if (insCode.isEmpty()) {
                this.pdbxPDBInsCode.markNextUnknown();
            } else {
                this.pdbxPDBInsCode.add(new String[]{insCode});
            }
            this.cartnX.add(new double[]{atom.getX()});
            this.cartnY.add(new double[]{atom.getY()});
            this.cartnZ.add(new double[]{atom.getZ()});
            this.occupancy.add(new double[]{atom.getOccupancy()});
            this.bIsoOrEquiv.add(new double[]{atom.getTempFactor()});
            this.authSeqId.add(new int[]{group.getResidueNumber().getSeqNum()});
            this.authCompId.add(new String[]{group.getPDBName()});
            this.authAsymId.add(new String[]{wrappedAtom.getChainName()});
            this.authAtomId.add(new String[]{atom.getName()});
            this.pdbxPDBModelNum.add(new int[]{wrappedAtom.getModel()});
        }

        AtomSiteCollector combine(AtomSiteCollector other) {
            throw new UnsupportedOperationException("impl by calling addAll for all collection - not feeling like writing that code");
        }

        Category get() {
            this.groupPDB.leaveColumn();
            this.id.leaveColumn();
            this.typeSymbol.leaveColumn();
            this.labelAtomId.leaveColumn();
            this.labelAltId.leaveColumn();
            this.labelCompId.leaveColumn();
            this.labelAsymId.leaveColumn();
            this.labelEntityId.leaveColumn();
            this.labelSeqId.leaveColumn();
            this.pdbxPDBInsCode.leaveColumn();
            this.cartnX.leaveColumn();
            this.cartnY.leaveColumn();
            this.cartnZ.leaveColumn();
            this.occupancy.leaveColumn();
            this.bIsoOrEquiv.leaveColumn();
            this.authSeqId.leaveColumn();
            this.authCompId.leaveColumn();
            this.authAsymId.leaveColumn();
            this.authAtomId.leaveColumn();
            this.pdbxPDBModelNum.leaveColumn();
            return this.atomSiteBuilder.build();
        }
    }

    static class WrappedAtom {
        private final Chain chain;
        private final int model;
        private final String chainName;
        private final String chainId;
        private final Atom atom;
        private final int atomId;

        WrappedAtom(Chain chain, int model, String chainName, String chainId, Atom atom, int atomId) {
            this.chain = chain;
            this.model = model;
            this.chainName = chainName;
            this.chainId = chainId;
            this.atom = atom;
            this.atomId = atomId;
        }

        Chain getChain() {
            return this.chain;
        }

        int getModel() {
            return this.model;
        }

        String getChainName() {
            return this.chainName;
        }

        String getChainId() {
            return this.chainId;
        }

        Atom getAtom() {
            return this.atom;
        }

        int getAtomId() {
            return this.atomId;
        }
    }
}

