/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializableCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(SerializableCache.class);
    protected String cacheFileName;
    protected Map<K, V> serializedCache;

    public SerializableCache(String cacheFileName) {
        this.cacheFileName = cacheFileName;
        if (cacheFileName != null) {
            this.reloadFromFile();
        }
    }

    public boolean isCacheEnabled() {
        return this.serializedCache != null;
    }

    public void cache(K name, V data) {
        if (data == null) {
            return;
        }
        if (this.serializedCache != null) {
            logger.debug("Caching {}  {}", name, data);
            this.serializedCache.put(name, data);
            if (this.serializedCache.keySet().size() % 1000 == 0) {
                this.flushCache();
            }
        }
    }

    public V get(K name) {
        if (this.serializedCache == null) {
            return null;
        }
        return this.serializedCache.get(name);
    }

    public void disableCache() {
        this.serializedCache = null;
    }

    public void enableCache() {
        this.reloadFromFile();
    }

    public Map<K, V> reloadFromFile() {
        File f = this.getCacheFile();
        this.serializedCache = new HashMap();
        if (!f.exists()) {
            logger.info("Creating new cache " + f.getAbsolutePath());
            return this.serializedCache;
        }
        try {
            logger.debug("Reloading from cache " + f.getAbsolutePath());
            FileInputStream fis = new FileInputStream(f);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.serializedCache = (HashMap)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            logger.error("Exception caught while reading serialized file", (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.error("Exception caught while reading serialized file", (Throwable)e);
            return null;
        }
        logger.info("Reloaded from cache: " + f.getName() + " size: " + this.serializedCache.keySet().size() + " cached records.");
        return this.serializedCache;
    }

    private File getCacheFile() {
        AtomCache cache = new AtomCache();
        String path = cache.getCachePath();
        File f = new File(path + System.getProperty("file.separator") + this.cacheFileName);
        logger.debug(f.getAbsolutePath());
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        if (this.serializedCache == null) {
            return;
        }
        Map<K, V> map = this.serializedCache;
        synchronized (map) {
            File f = this.getCacheFile();
            try {
                FileOutputStream fos = new FileOutputStream(f);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this.serializedCache);
                oos.close();
            }
            catch (IOException e) {
                logger.error("Exception caught", (Throwable)e);
            }
        }
    }
}

