/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.AtomPositionMap;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.ResidueRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResidueRangeAndLength
extends ResidueRange {
    private static final Logger logger = LoggerFactory.getLogger(ResidueRangeAndLength.class);
    private final int length;

    public ResidueRangeAndLength(String chain, ResidueNumber start, ResidueNumber end, int length) {
        super(chain, start, end);
        this.length = length;
    }

    public ResidueRangeAndLength(String chain, String start, String end, int length) {
        super(chain, start, end);
        this.length = length;
    }

    @Override
    public Iterator<ResidueNumber> iterator(AtomPositionMap map) {
        return super.iterator(map);
    }

    public static int calcLength(List<ResidueRangeAndLength> rrs) {
        int l = 0;
        for (ResidueRangeAndLength rr : rrs) {
            l += rr.getLength();
        }
        return l;
    }

    public static ResidueRangeAndLength parse(String s, AtomPositionMap map) {
        ResidueNumber end;
        ResidueRange rr = ResidueRangeAndLength.parse(s);
        ResidueNumber start = rr.getStart();
        String chain = rr.getChainName();
        if (chain == null || "_".equals(chain)) {
            ResidueNumber first = (ResidueNumber)map.getNavMap().firstKey();
            chain = first.getChainName();
            if (!((ResidueNumber)map.getNavMap().lastKey()).getChainName().equals(chain)) {
                logger.warn("Multiple possible chains match '_'. Using chain {}", (Object)chain);
            }
        }
        if (start == null) {
            start = map.getFirst(chain);
        }
        if ((end = rr.getEnd()) == null) {
            end = map.getLast(chain);
        }
        start.setChainName(chain);
        end.setChainName(chain);
        return map.trimToValidResidues(new ResidueRange(chain, start, end));
    }

    public static List<ResidueRangeAndLength> parseMultiple(List<String> ranges, AtomPositionMap map) {
        ArrayList<ResidueRangeAndLength> rrs = new ArrayList<ResidueRangeAndLength>(ranges.size());
        for (String range : ranges) {
            ResidueRangeAndLength rr = ResidueRangeAndLength.parse(range, map);
            if (rr == null) continue;
            rrs.add(rr);
        }
        return rrs;
    }

    public static List<ResidueRangeAndLength> parseMultiple(String s, AtomPositionMap map) {
        String[] parts = s.split(",");
        ArrayList<ResidueRangeAndLength> list = new ArrayList<ResidueRangeAndLength>(parts.length);
        for (String part : parts) {
            list.add(ResidueRangeAndLength.parse(part, map));
        }
        return list;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResidueRangeAndLength that = (ResidueRangeAndLength)o;
        return this.length == that.length;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.length;
        return result;
    }
}

