/*
 * Decompiled with CFR 0.152.
 */
package org.n0pe.asadmin.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.n0pe.asadmin.AbstractAsAdminCmd;
import org.n0pe.asadmin.AsAdminException;

public class CreateFileUser
extends AbstractAsAdminCmd {
    public static final String CREATE_FILE_USER = "create-file-user";
    public static final String GROUPS = "--groups";
    private String userName;
    private char[] password;
    private String group;

    private CreateFileUser() {
    }

    public CreateFileUser(String userName) {
        this.userName = userName;
    }

    public CreateFileUser withPassword(char[] password) {
        this.password = password;
        return this;
    }

    public CreateFileUser withGroup(String group) {
        this.group = group;
        return this;
    }

    public boolean needCredentials() {
        return true;
    }

    public String getActionCommand() {
        if (this.userName == null) {
            throw new IllegalStateException();
        }
        return CREATE_FILE_USER;
    }

    public String[] getParameters() {
        String[] params = new String[]{GROUPS, this.group, this.userName};
        return params;
    }

    public String handlePasswordFile(String configuredPasswordFile) throws AsAdminException {
        try {
            File passwordTempFile = File.createTempFile("asadmin-create-file-user", ".pwd");
            passwordTempFile.deleteOnExit();
            FileUtils.copyFile((File)new File(configuredPasswordFile), (File)passwordTempFile);
            BufferedWriter out = new BufferedWriter(new FileWriter(passwordTempFile));
            out.write("AS_ADMIN_USERPASSWORD=" + new String(this.password));
            out.close();
            return passwordTempFile.getAbsolutePath();
        }
        catch (IOException ex) {
            throw new AsAdminException("Unable to handle password file for CreateFileUser command", ex);
        }
    }
}

