/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.api.BatchExtension;
import org.sonar.api.PropertyType;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.Settings;

public class JacocoConfiguration
implements BatchExtension {
    public static final String REPORT_PATH_PROPERTY = "sonar.jacoco.reportPath";
    public static final String REPORT_PATH_DEFAULT_VALUE = "target/jacoco.exec";
    public static final String IT_REPORT_PATH_PROPERTY = "sonar.jacoco.itReportPath";
    public static final String IT_REPORT_PATH_DEFAULT_VALUE = "target/jacoco-it.exec";
    public static final String REPORT_MISSING_FORCE_ZERO = "sonar.jacoco.reportMissing.force.zero";
    public static final boolean REPORT_MISSING_FORCE_ZERO_DEFAULT_VALUE = false;
    private final Settings settings;
    private final FileSystem fileSystem;

    public JacocoConfiguration(Settings settings, FileSystem fileSystem) {
        this.settings = settings;
        this.fileSystem = fileSystem;
    }

    public boolean shouldExecuteOnProject(boolean reportFound) {
        return this.hasJavaFiles() && (reportFound || this.isCoverageToZeroWhenNoReport());
    }

    private boolean hasJavaFiles() {
        return this.fileSystem.hasFiles(this.fileSystem.predicates().hasLanguage("java"));
    }

    public String getReportPath() {
        return this.settings.getString(REPORT_PATH_PROPERTY);
    }

    public String getItReportPath() {
        return this.settings.getString(IT_REPORT_PATH_PROPERTY);
    }

    private boolean isCoverageToZeroWhenNoReport() {
        return this.settings.getBoolean(REPORT_MISSING_FORCE_ZERO);
    }

    public static List<PropertyDefinition> getPropertyDefinitions() {
        String subCategory = "JaCoCo";
        return ImmutableList.of((Object)PropertyDefinition.builder((String)REPORT_PATH_PROPERTY).defaultValue(REPORT_PATH_DEFAULT_VALUE).category("java").subCategory(subCategory).name("UT JaCoCo Report").description("Path to the JaCoCo report file containing coverage data by unit tests. The path may be absolute or relative to the project base directory.").onQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)IT_REPORT_PATH_PROPERTY).defaultValue(IT_REPORT_PATH_DEFAULT_VALUE).category("java").subCategory(subCategory).name("IT JaCoCo Report").description("Path to the JaCoCo report file containing coverage data by integration tests. The path may be absolute or relative to the project base directory.").onQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)REPORT_MISSING_FORCE_ZERO).defaultValue("false").name("Force zero coverage").category("java").subCategory(subCategory).description("Force coverage to 0% if no JaCoCo reports are found during analysis.").onQualifiers("TRK", new String[]{"BRC"}).type(PropertyType.BOOLEAN).build());
    }
}

