/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.indexer.SquidIndex;

public class DefaultJavaResourceLocator
implements JavaResourceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(JavaResourceLocator.class);
    private final Project project;
    private final ModuleFileSystem fileSystem;
    private Map<String, Resource> resourcesCache;

    public DefaultJavaResourceLocator(Project project, ModuleFileSystem fileSystem) {
        this.project = project;
        this.fileSystem = fileSystem;
    }

    public void setSquidIndex(SquidIndex squidIndex) {
        this.resourcesCache = Maps.newHashMap();
        for (SourceCode sourceClass : squidIndex.search(new Query[]{new QueryByType(SourceClass.class)})) {
            String filePath = ((SourceFile)sourceClass.getParent(SourceFile.class)).getName();
            org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)new File(filePath), (Project)this.project);
            this.resourcesCache.put(sourceClass.getKey(), (Resource)resource);
        }
    }

    public Resource findResourceByClassName(String className) {
        String name = className.replace('.', '/');
        Resource resource = this.resourcesCache.get(name);
        if (resource == null) {
            LOG.debug("Class not found in SquidIndex: {}", (Object)className);
        }
        return resource;
    }

    public Collection<File> classFilesToAnalyze() {
        ImmutableList.Builder result = ImmutableList.builder();
        block0: for (String key : this.resourcesCache.keySet()) {
            String filePath = key + ".class";
            for (File binaryDir : this.fileSystem.binaryDirs()) {
                File classFile = new File(binaryDir, filePath);
                if (!classFile.isFile()) continue;
                result.add((Object)classFile);
                continue block0;
            }
        }
        return result.build();
    }
}

