/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.plugins.java.bridges.Bridge;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.measures.MetricDef;

public final class CopyBasicMeasuresBridge
extends Bridge {
    private static final Number[] LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};

    @Override
    public void onFile(SourceFile squidFile, Resource sonarResource) {
        this.copy((SourceCode)squidFile, sonarResource, (MetricDef)JavaMetric.LINES_OF_CODE, CoreMetrics.NCLOC);
        this.copy((SourceCode)squidFile, sonarResource, (MetricDef)JavaMetric.LINES, CoreMetrics.LINES);
        this.copy((SourceCode)squidFile, sonarResource, (MetricDef)JavaMetric.COMMENT_LINES_WITHOUT_HEADER, CoreMetrics.COMMENT_LINES);
        this.copy((SourceCode)squidFile, sonarResource, (MetricDef)JavaMetric.STATEMENTS, CoreMetrics.STATEMENTS);
        this.copy((SourceCode)squidFile, sonarResource, (MetricDef)JavaMetric.CLASSES, CoreMetrics.CLASSES);
        this.copy((SourceCode)squidFile, sonarResource, (MetricDef)JavaMetric.COMPLEXITY, CoreMetrics.COMPLEXITY);
        this.context.saveMeasure(sonarResource, new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, LIMITS).add((Number)squidFile.getInt((MetricDef)JavaMetric.COMPLEXITY)).build(true).setPersistenceMode(PersistenceMode.MEMORY));
        this.copy((SourceCode)squidFile, sonarResource, (MetricDef)org.sonar.squidbridge.measures.Metric.PUBLIC_API, CoreMetrics.PUBLIC_API);
        double undocumentedApiDensity = ParsingUtils.scaleValue((double)(squidFile.getDouble(org.sonar.squidbridge.measures.Metric.PUBLIC_DOCUMENTED_API_DENSITY) * 100.0), (int)2);
        this.context.saveMeasure(sonarResource, new Measure(CoreMetrics.PUBLIC_DOCUMENTED_API_DENSITY, Double.valueOf(undocumentedApiDensity)));
        double undocumentedApi = squidFile.getDouble(org.sonar.squidbridge.measures.Metric.PUBLIC_API) - (double)squidFile.getInt(org.sonar.squidbridge.measures.Metric.PUBLIC_DOC_API);
        this.context.saveMeasure(sonarResource, new Measure(CoreMetrics.PUBLIC_UNDOCUMENTED_API, Double.valueOf(undocumentedApi)));
    }

    private void copy(SourceCode squidResource, Resource sonarResource, MetricDef squidMetric, Metric sonarMetric) {
        this.context.saveMeasure(sonarResource, new Measure(sonarMetric, Double.valueOf(squidResource.getDouble(squidMetric))));
    }
}

