/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.design.Dependency;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.graph.DirectedGraphAccessor;
import org.sonar.graph.Dsm;
import org.sonar.graph.DsmTopologicalSorter;
import org.sonar.graph.Edge;
import org.sonar.graph.IncrementalCyclesAndFESSolver;
import org.sonar.graph.MinimumFeedbackEdgeSetSolver;
import org.sonar.java.JavaSquid;
import org.sonar.java.checks.CycleBetweenPackagesCheck;
import org.sonar.plugins.java.bridges.Bridge;
import org.sonar.plugins.java.bridges.DependencyIndex;
import org.sonar.plugins.java.bridges.DsmSerializer;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceCodeEdge;
import org.sonar.squidbridge.api.SourcePackage;
import org.sonar.squidbridge.api.SourceProject;

public class DesignBridge
extends Bridge {
    private static final Logger LOG = LoggerFactory.getLogger(DesignBridge.class);
    private DependencyIndex dependencyIndex = new DependencyIndex();

    @Override
    public boolean needsBytecode() {
        return true;
    }

    @Override
    public void onProject(SourceProject squidProject, Project sonarProject) {
        Set squidPackages = squidProject.getChildren();
        if (squidPackages != null) {
            if ((squidPackages = Sets.filter((Set)squidPackages, (Predicate)new Predicate<SourceCode>(){

                public boolean apply(@Nullable SourceCode input) {
                    return input != null && !"!error!".equals(input.getKey());
                }
            })).isEmpty()) {
                return;
            }
            TimeProfiler profiler = new TimeProfiler(LOG).start("Package design analysis");
            LOG.debug("{} packages to analyze", (Object)squidPackages.size());
            this.savePackageDependencies(squidPackages);
            IncrementalCyclesAndFESSolver cyclesAndFESSolver = new IncrementalCyclesAndFESSolver((DirectedGraphAccessor)this.squid, (Collection)squidPackages);
            LOG.debug("{} cycles", (Object)cyclesAndFESSolver.getCycles().size());
            Set feedbackEdges = cyclesAndFESSolver.getFeedbackEdgeSet();
            LOG.debug("{} feedback edges", (Object)feedbackEdges.size());
            int tangles = cyclesAndFESSolver.getWeightOfFeedbackEdgeSet();
            this.saveViolations(feedbackEdges);
            this.savePositiveMeasure((Resource)sonarProject, CoreMetrics.PACKAGE_CYCLES, cyclesAndFESSolver.getCycles().size());
            this.savePositiveMeasure((Resource)sonarProject, CoreMetrics.PACKAGE_FEEDBACK_EDGES, feedbackEdges.size());
            this.savePositiveMeasure((Resource)sonarProject, CoreMetrics.PACKAGE_TANGLES, tangles);
            this.savePositiveMeasure((Resource)sonarProject, CoreMetrics.PACKAGE_EDGES_WEIGHT, this.getEdgesWeight(squidPackages));
            String dsmJson = this.serializeDsm(this.squid, squidPackages, feedbackEdges);
            Measure dsmMeasure = new Measure(CoreMetrics.DEPENDENCY_MATRIX, dsmJson).setPersistenceMode(PersistenceMode.DATABASE);
            this.context.saveMeasure((Resource)sonarProject, dsmMeasure);
            profiler.stop();
        }
    }

    private void savePositiveMeasure(Resource sonarResource, Metric metric, double value) {
        if (value >= 0.0) {
            this.context.saveMeasure(sonarResource, metric, Double.valueOf(value));
        }
    }

    @Override
    public void onPackage(SourcePackage squidPackage, Resource sonarPackage) {
        Set squidFiles = squidPackage.getChildren();
        if (squidFiles != null && !squidFiles.isEmpty()) {
            this.saveFileDependencies(squidFiles);
            IncrementalCyclesAndFESSolver cycleDetector = new IncrementalCyclesAndFESSolver((DirectedGraphAccessor)this.squid, (Collection)squidFiles);
            Set cycles = cycleDetector.getCycles();
            MinimumFeedbackEdgeSetSolver solver = new MinimumFeedbackEdgeSetSolver(cycles);
            Set feedbackEdges = solver.getEdges();
            int tangles = solver.getWeightOfFeedbackEdgeSet();
            this.savePositiveMeasure(sonarPackage, CoreMetrics.FILE_CYCLES, cycles.size());
            this.savePositiveMeasure(sonarPackage, CoreMetrics.FILE_FEEDBACK_EDGES, feedbackEdges.size());
            this.savePositiveMeasure(sonarPackage, CoreMetrics.FILE_TANGLES, tangles);
            this.savePositiveMeasure(sonarPackage, CoreMetrics.FILE_EDGES_WEIGHT, this.getEdgesWeight(squidFiles));
            String dsmJson = this.serializeDsm(this.squid, squidFiles, feedbackEdges);
            this.context.saveMeasure(sonarPackage, new Measure(CoreMetrics.DEPENDENCY_MATRIX, dsmJson));
        }
    }

    private double getEdgesWeight(Collection<SourceCode> sourceCodes) {
        List edges = this.squid.getEdges(sourceCodes);
        double total = 0.0;
        for (SourceCodeEdge edge : edges) {
            total += (double)edge.getWeight();
        }
        return total;
    }

    private String serializeDsm(JavaSquid squid, Set<SourceCode> squidSources, Set<Edge> feedbackEdges) {
        Dsm dsm = new Dsm((DirectedGraphAccessor)squid, squidSources, feedbackEdges);
        DsmTopologicalSorter.sort((Dsm)dsm);
        return DsmSerializer.serialize((Dsm<SourceCode>)dsm, this.dependencyIndex, this.resourceIndex);
    }

    public void savePackageDependencies(Set<SourceCode> squidPackages) {
        for (SourceCode squidPackage : squidPackages) {
            for (SourceCodeEdge edge : this.squid.getOutgoingEdges(squidPackage)) {
                Dependency dependency = this.saveEdge(edge, this.context, null);
                if (dependency == null) continue;
                for (SourceCodeEdge subEdge : edge.getRootEdges()) {
                    this.saveEdge(subEdge, this.context, dependency);
                }
            }
        }
    }

    private void saveViolations(Set<Edge> feedbackEdges) {
        ActiveRule rule = CycleBetweenPackagesCheck.getActiveRule((CheckFactory)this.checkFactory);
        if (rule == null) {
            return;
        }
        for (Edge feedbackEdge : feedbackEdges) {
            SourcePackage fromPackage = (SourcePackage)feedbackEdge.getFrom();
            SourcePackage toPackage = (SourcePackage)feedbackEdge.getTo();
            SourceCodeEdge edge = this.squid.getEdge((SourceCode)fromPackage, (SourceCode)toPackage);
            for (SourceCodeEdge subEdge : edge.getRootEdges()) {
                Resource fromFile = (Resource)this.resourceIndex.get(subEdge.getFrom());
                Resource toFile = (Resource)this.resourceIndex.get(subEdge.getTo());
                if (fromFile == null || toFile == null) continue;
                Violation violation = Violation.create((ActiveRule)rule, (Resource)fromFile).setMessage("Remove the dependency on the source file \"" + toFile.getLongName() + "\" to break a package cycle.").setCost(Double.valueOf(subEdge.getWeight()));
                this.context.saveViolation(violation);
            }
        }
    }

    public void saveFileDependencies(Set<SourceCode> squidFiles) {
        for (SourceCode squidFile : squidFiles) {
            for (SourceCodeEdge edge : this.squid.getOutgoingEdges(squidFile)) {
                this.saveEdge(edge, this.context, null);
            }
        }
    }

    private Dependency saveEdge(SourceCodeEdge edge, SensorContext context, Dependency parentDependency) {
        Dependency dependency = (Dependency)this.dependencyIndex.get(edge);
        if (dependency == null) {
            Resource from = (Resource)this.resourceIndex.get(edge.getFrom());
            Resource to = (Resource)this.resourceIndex.get(edge.getTo());
            if (from != null && to != null) {
                dependency = new Dependency(from, to).setUsage(edge.getUsage().name()).setWeight(edge.getWeight()).setParent(parentDependency);
                context.saveDependency(dependency);
                this.dependencyIndex.put(edge, dependency);
            } else {
                if (from == null) {
                    LOG.warn("Unable to find resource '" + edge.getFrom() + "' to create a dependency with '" + edge.getTo() + "'");
                }
                if (to == null) {
                    LOG.warn("Unable to find resource '" + edge.getTo() + "' to create a dependency with '" + edge.getFrom() + "'");
                }
                return null;
            }
        }
        return dependency;
    }
}

