/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.design.Dependency;
import org.sonar.api.issue.Issuable;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.graph.DirectedGraph;
import org.sonar.graph.Dsm;
import org.sonar.graph.DsmTopologicalSorter;
import org.sonar.graph.Edge;
import org.sonar.graph.IncrementalCyclesAndFESSolver;
import org.sonar.graph.MinimumFeedbackEdgeSetSolver;
import org.sonar.java.bytecode.visitor.ResourceMapping;
import org.sonar.java.checks.CycleBetweenPackagesCheck;
import org.sonar.plugins.java.bridges.DsmSerializer;

public class DesignBridge {
    private static final Logger LOG = LoggerFactory.getLogger(DesignBridge.class);
    private final SensorContext context;
    private final DirectedGraph<Resource, Dependency> graph;
    private final ResourceMapping resourceMapping;
    private final ResourcePerspectives resourcePerspectives;

    public DesignBridge(SensorContext context, DirectedGraph<Resource, Dependency> graph, ResourceMapping resourceMapping, ResourcePerspectives resourcePerspectives) {
        this.context = context;
        this.graph = graph;
        this.resourceMapping = resourceMapping;
        this.resourcePerspectives = resourcePerspectives;
    }

    public void saveDesign(Project sonarProject) {
        Set directories = this.resourceMapping.directories();
        TimeProfiler profiler = new TimeProfiler(LOG).start("Package design analysis");
        LOG.debug("{} packages to analyze", (Object)directories.size());
        IncrementalCyclesAndFESSolver cyclesAndFESSolver = new IncrementalCyclesAndFESSolver(this.graph, (Collection)directories);
        LOG.debug("{} cycles", (Object)cyclesAndFESSolver.getCycles().size());
        Set feedbackEdges = cyclesAndFESSolver.getFeedbackEdgeSet();
        LOG.debug("{} feedback edges", (Object)feedbackEdges.size());
        int tangles = cyclesAndFESSolver.getWeightOfFeedbackEdgeSet();
        this.saveIssues(feedbackEdges);
        this.saveDependencies();
        this.savePositiveMeasure((Resource)sonarProject, CoreMetrics.PACKAGE_CYCLES, cyclesAndFESSolver.getCycles().size());
        this.savePositiveMeasure((Resource)sonarProject, CoreMetrics.PACKAGE_FEEDBACK_EDGES, feedbackEdges.size());
        this.savePositiveMeasure((Resource)sonarProject, CoreMetrics.PACKAGE_TANGLES, tangles);
        this.savePositiveMeasure((Resource)sonarProject, CoreMetrics.PACKAGE_EDGES_WEIGHT, this.getEdgesWeight(directories));
        String dsmJson = this.serializeDsm(this.graph, directories, feedbackEdges);
        Measure dsmMeasure = new Measure(CoreMetrics.DEPENDENCY_MATRIX, dsmJson).setPersistenceMode(PersistenceMode.DATABASE);
        this.context.saveMeasure((Resource)sonarProject, dsmMeasure);
        profiler.stop();
        for (Resource sonarPackage : directories) {
            this.onPackage(sonarPackage);
        }
    }

    private void savePositiveMeasure(Resource sonarResource, Metric metric, double value) {
        if (value >= 0.0) {
            this.context.saveMeasure(sonarResource, metric, Double.valueOf(value));
        }
    }

    private void onPackage(Resource sonarPackage) {
        Collection squidFiles = this.resourceMapping.files((Directory)sonarPackage);
        if (squidFiles != null && !squidFiles.isEmpty()) {
            IncrementalCyclesAndFESSolver cycleDetector = new IncrementalCyclesAndFESSolver(this.graph, squidFiles);
            Set cycles = cycleDetector.getCycles();
            MinimumFeedbackEdgeSetSolver solver = new MinimumFeedbackEdgeSetSolver(cycles);
            Set feedbackEdges = solver.getEdges();
            int tangles = solver.getWeightOfFeedbackEdgeSet();
            this.savePositiveMeasure(sonarPackage, CoreMetrics.FILE_CYCLES, cycles.size());
            this.savePositiveMeasure(sonarPackage, CoreMetrics.FILE_FEEDBACK_EDGES, feedbackEdges.size());
            this.savePositiveMeasure(sonarPackage, CoreMetrics.FILE_TANGLES, tangles);
            this.savePositiveMeasure(sonarPackage, CoreMetrics.FILE_EDGES_WEIGHT, this.getEdgesWeight(squidFiles));
            String dsmJson = this.serializeDsm(this.graph, squidFiles, feedbackEdges);
            this.context.saveMeasure(sonarPackage, new Measure(CoreMetrics.DEPENDENCY_MATRIX, dsmJson));
        }
    }

    private double getEdgesWeight(Collection<Resource> resources) {
        List edges = this.graph.getEdges(resources);
        double total = 0.0;
        for (Dependency edge : edges) {
            total += (double)edge.getWeight();
        }
        return total;
    }

    private String serializeDsm(DirectedGraph<Resource, Dependency> graph, Collection<Resource> sources, Set<Edge> feedbackEdges) {
        Dsm dsm = new Dsm(graph, sources, feedbackEdges);
        DsmTopologicalSorter.sort((Dsm)dsm);
        return DsmSerializer.serialize((Dsm<Resource>)dsm);
    }

    private void saveIssues(Set<Edge> feedbackEdges) {
        for (Edge feedbackEdge : feedbackEdges) {
            for (Dependency subDependency : this.resourceMapping.getSubDependencies((Dependency)feedbackEdge)) {
                Resource fromFile = subDependency.getFrom();
                Resource toFile = subDependency.getTo();
                Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, fromFile);
                issuable.addIssue(issuable.newIssueBuilder().ruleKey(CycleBetweenPackagesCheck.RULE_KEY).effortToFix(Double.valueOf(subDependency.getWeight())).message("Remove the dependency on the source file \"" + toFile.getLongName() + "\" to break a package cycle.").build());
            }
        }
    }

    private void saveDependencies() {
        for (Resource resource : this.graph.getVertices()) {
            for (Dependency dependency : this.graph.getOutgoingEdges((Object)resource)) {
                this.context.saveDependency(dependency);
            }
        }
    }
}

