/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.java.DefaultJavaResourceLocator;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.JavaSquid;
import org.sonar.java.Measurer;
import org.sonar.java.SonarComponents;
import org.sonar.java.checks.CheckList;
import org.sonar.plugins.java.Bridges;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.squidbridge.api.CodeVisitor;

@Phase(name=Phase.Name.PRE)
@DependsUpon(value={"BEFORE_SQUID"})
@DependedUpon(value={"squid"})
public class JavaSquidSensor
implements Sensor {
    private final JavaClasspath javaClasspath;
    private final SonarComponents sonarComponents;
    private final FileSystem fs;
    private final DefaultJavaResourceLocator javaResourceLocator;
    private final Settings settings;
    private final CheckFactory checkFactory;
    private final RulesProfile profile;
    private final NoSonarFilter noSonarFilter;

    public JavaSquidSensor(RulesProfile profile, JavaClasspath javaClasspath, SonarComponents sonarComponents, FileSystem fs, DefaultJavaResourceLocator javaResourceLocator, Settings settings, NoSonarFilter noSonarFilter, CheckFactory checkFactory) {
        this.profile = profile;
        this.noSonarFilter = noSonarFilter;
        this.javaClasspath = javaClasspath;
        this.sonarComponents = sonarComponents;
        this.fs = fs;
        this.javaResourceLocator = javaResourceLocator;
        this.settings = settings;
        this.checkFactory = checkFactory;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.fs.hasFiles(this.fs.predicates().hasLanguage("java"));
    }

    public void analyse(Project project, SensorContext context) {
        Checks checks = this.checkFactory.create("squid").addAnnotatedChecks((Collection)CheckList.getChecks());
        Collection checkList = checks.all();
        JavaConfiguration configuration = this.createConfiguration();
        Measurer measurer = new Measurer(project, context, configuration.isAnalysePropertyAccessors());
        JavaSquid squid = new JavaSquid(configuration, this.sonarComponents, measurer, (JavaResourceLocator)this.javaResourceLocator, checkList.toArray(new CodeVisitor[checkList.size()]));
        squid.scan(this.getSourceFiles(), this.getTestFiles(), this.getBytecodeFiles());
        new Bridges(squid, this.settings).save(context, project, (Checks<CodeVisitor>)checks, this.javaResourceLocator.getResourceMapping(), this.sonarComponents.getResourcePerspectives(), this.noSonarFilter, this.profile, this.javaResourceLocator.getIgnoredLinesForRules());
    }

    private Iterable<File> getSourceFiles() {
        return this.toFile(this.fs.inputFiles(this.fs.predicates().and(this.fs.predicates().hasLanguage("java"), this.fs.predicates().hasType(InputFile.Type.MAIN))));
    }

    private Iterable<File> getTestFiles() {
        return this.toFile(this.fs.inputFiles(this.fs.predicates().and(this.fs.predicates().hasLanguage("java"), this.fs.predicates().hasType(InputFile.Type.TEST))));
    }

    private Iterable<File> toFile(Iterable<InputFile> inputFiles) {
        ArrayList files = Lists.newArrayList();
        for (InputFile inputFile : inputFiles) {
            files.add(inputFile.file());
        }
        return files;
    }

    private List<File> getBytecodeFiles() {
        if (this.settings.getBoolean("sonar.skipDesign")) {
            return Collections.emptyList();
        }
        return this.javaClasspath.getElements();
    }

    private JavaConfiguration createConfiguration() {
        boolean analyzePropertyAccessors = this.settings.getBoolean("sonar.squid.analyse.property.accessors");
        Charset charset = this.fs.encoding();
        JavaConfiguration conf = new JavaConfiguration(charset);
        conf.setAnalyzePropertyAccessors(analyzePropertyAccessors);
        return conf;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

