/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.channel;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;

public class UnknownCharacterChannel
extends Channel<Lexer> {
    private static final Logger LOG = LoggerFactory.getLogger(UnknownCharacterChannel.class);
    private boolean shouldLogWarning = false;
    private final Token.Builder tokenBuilder = Token.builder();

    public UnknownCharacterChannel() {
    }

    public UnknownCharacterChannel(boolean shouldLogWarning) {
        this.shouldLogWarning = shouldLogWarning;
    }

    @Override
    public boolean consume(CodeReader code, Lexer lexer) {
        if (code.peek() != -1) {
            char unknownChar = (char)code.pop();
            if (this.shouldLogWarning) {
                LOG.warn("Unknown char: \"" + unknownChar + "\" (" + lexer.getURI() + ":" + code.getLinePosition() + ":" + code.getColumnPosition() + ")");
            }
            Token token = this.tokenBuilder.setType(GenericTokenType.UNKNOWN_CHAR).setValueAndOriginalValue(String.valueOf(unknownChar)).setURI(lexer.getURI()).setLine(code.getLinePosition()).setColumn(code.getColumnPosition() - 1).build();
            lexer.addToken(token);
            return true;
        }
        return false;
    }
}

