/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.colorizer;

import java.util.HashMap;
import java.util.Map;

public class HtmlCodeBuilder
implements Appendable {
    private StringBuilder colorizedCode = new StringBuilder();
    private Map variables = new HashMap();

    public Appendable append(CharSequence csq) {
        for (int i = 0; i < csq.length(); ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    public Appendable append(char c) {
        if (c == '<') {
            this.colorizedCode.append("&lt;");
        } else if (c == '>') {
            this.colorizedCode.append("&gt;");
        } else {
            this.colorizedCode.append(c);
        }
        return this;
    }

    public Appendable append(CharSequence csq, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    public void appendWithoutTransforming(String htmlTag) {
        this.colorizedCode.append(htmlTag);
    }

    public String toString() {
        return this.colorizedCode.toString();
    }

    public StringBuilder getColorizedCode() {
        return this.colorizedCode;
    }

    public void setVariable(Object key, Object value) {
        this.variables.put(key, value);
    }

    public Object getVariable(Object key) {
        return this.variables.get(key);
    }

    public Object getVariable(Object key, Object defaultValue) {
        Object result = this.variables.get(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public Map getVariables() {
        return this.variables;
    }
}

