/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.java.ast.visitors.PublicApiVisitor;
import org.sonar.java.ast.visitors.SuppressWarningsAnnotationUtils;
import org.sonar.java.signature.JvmJavaType;
import org.sonar.java.signature.MethodSignature;
import org.sonar.java.signature.MethodSignaturePrinter;
import org.sonar.java.signature.Parameter;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.measures.MetricDef;

public class MethodVisitor
extends JavaAstVisitor {
    private static final Map<JavaKeyword, JvmJavaType> JAVA_TYPE_MAPPING = Maps.newHashMap();

    public void init() {
        MethodHelper.subscribe(this);
    }

    public void visitNode(AstNode astNode) {
        String methodName = this.buildMethodSignature(new MethodHelper(astNode));
        SourceClass sourceClass = this.peekSourceClass();
        int startLine = PublicApiVisitor.getDeclaration(astNode).getTokenLine();
        SourceMethod sourceMethod = new SourceMethod(sourceClass, methodName, startLine);
        sourceMethod.setMeasure((MetricDef)JavaMetric.METHODS, 1);
        sourceMethod.setSuppressWarnings(SuppressWarningsAnnotationUtils.isSuppressAllWarnings(astNode));
        this.getContext().addSourceCode((SourceCode)sourceMethod);
    }

    public void leaveNode(AstNode astNode) {
        this.getContext().popSourceCode();
    }

    private String buildMethodSignature(MethodHelper methodHelper) {
        String methodName = this.extractMethodName(methodHelper);
        Parameter returnType = this.extractMethodReturnType(methodHelper);
        List<Parameter> argumentTypes = this.extractMethodArgumentTypes(methodHelper);
        MethodSignature signature = new MethodSignature(methodName, returnType, argumentTypes);
        return MethodSignaturePrinter.print(signature);
    }

    private String extractMethodName(MethodHelper methodHelper) {
        if (methodHelper.isConstructor()) {
            return "<init>";
        }
        return methodHelper.getName().getTokenValue();
    }

    private Parameter extractMethodReturnType(MethodHelper methodHelper) {
        if (methodHelper.isConstructor()) {
            return new Parameter(JvmJavaType.V, false);
        }
        AstNode returnType = methodHelper.getReturnType();
        boolean isArray = returnType.hasDirectChildren(JavaGrammar.DIM);
        return new Parameter(this.extractArgumentAndReturnType(returnType, isArray));
    }

    private List<Parameter> extractMethodArgumentTypes(MethodHelper methodHelper) {
        ArrayList<Parameter> argumentTypes = Lists.newArrayList();
        for (AstNode astNode : methodHelper.getParameters()) {
            AstNode type = astNode.getFirstChild(JavaGrammar.TYPE);
            boolean isArray = type.hasDirectChildren(JavaGrammar.DIM) || astNode.getFirstChild(JavaGrammar.FORMAL_PARAMETERS_DECLS_REST).getFirstChild(JavaGrammar.VARIABLE_DECLARATOR_ID).hasDirectChildren(JavaGrammar.DIM);
            argumentTypes.add(this.extractArgumentAndReturnType(type, isArray));
        }
        return argumentTypes;
    }

    private Parameter extractArgumentAndReturnType(AstNode astNode, boolean isArray) {
        Preconditions.checkArgument(astNode.is(JavaKeyword.VOID, JavaGrammar.TYPE));
        if (astNode.is(JavaKeyword.VOID)) {
            return new Parameter(JvmJavaType.V, false);
        }
        if (astNode.getFirstChild().is(JavaGrammar.BASIC_TYPE)) {
            return new Parameter(JAVA_TYPE_MAPPING.get(astNode.getFirstChild().getFirstChild().getType()), isArray);
        }
        if (astNode.getFirstChild().is(JavaGrammar.CLASS_TYPE)) {
            return new Parameter(this.extractClassName(astNode.getFirstChild()), isArray);
        }
        throw new IllegalStateException();
    }

    private String extractClassName(AstNode astNode) {
        Preconditions.checkArgument(astNode.is(JavaGrammar.CLASS_TYPE));
        return Iterables.getLast(astNode.getChildren(JavaTokenType.IDENTIFIER)).getTokenValue();
    }

    static {
        JAVA_TYPE_MAPPING.put(JavaKeyword.BYTE, JvmJavaType.B);
        JAVA_TYPE_MAPPING.put(JavaKeyword.CHAR, JvmJavaType.C);
        JAVA_TYPE_MAPPING.put(JavaKeyword.SHORT, JvmJavaType.S);
        JAVA_TYPE_MAPPING.put(JavaKeyword.INT, JvmJavaType.I);
        JAVA_TYPE_MAPPING.put(JavaKeyword.LONG, JvmJavaType.J);
        JAVA_TYPE_MAPPING.put(JavaKeyword.BOOLEAN, JvmJavaType.Z);
        JAVA_TYPE_MAPPING.put(JavaKeyword.FLOAT, JvmJavaType.F);
        JAVA_TYPE_MAPPING.put(JavaKeyword.DOUBLE, JvmJavaType.D);
        JAVA_TYPE_MAPPING.put(JavaKeyword.VOID, JvmJavaType.V);
    }
}

