/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ConditionalExpressionTreeImpl
extends AbstractTypedTree
implements ConditionalExpressionTree {
    private final ExpressionTree condition;
    private final ExpressionTree trueExpression;
    private final ExpressionTree falseExpression;

    public ConditionalExpressionTreeImpl(AstNode astNode, ExpressionTree condition, ExpressionTree trueExpression, ExpressionTree falseExpression) {
        super(astNode);
        this.condition = Preconditions.checkNotNull(condition);
        this.trueExpression = Preconditions.checkNotNull(trueExpression);
        this.falseExpression = Preconditions.checkNotNull(falseExpression);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CONDITIONAL_EXPRESSION;
    }

    public ExpressionTree condition() {
        return this.condition;
    }

    public ExpressionTree trueExpression() {
        return this.trueExpression;
    }

    public ExpressionTree falseExpression() {
        return this.falseExpression;
    }

    public void accept(TreeVisitor visitor) {
        visitor.visitConditionalExpression((ConditionalExpressionTree)this);
    }
}

