/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="BoundOrAssignedEvalOrArguments", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class BoundOrAssignedEvalOrArgumentsCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.CATCH, EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN, EcmaScriptGrammar.PROPERTY_SET_PARAMETER_LIST, EcmaScriptGrammar.ASSIGNMENT_EXPRESSION, EcmaScriptGrammar.POSTFIX_EXPRESSION, EcmaScriptGrammar.UNARY_EXPRESSION});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION})) {
            this.checkFunction(astNode);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.CATCH, EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN})) {
            this.checkVariableDeclaration(astNode);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.PROPERTY_SET_PARAMETER_LIST})) {
            this.checkPropertySetParameterList(astNode);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.ASSIGNMENT_EXPRESSION})) {
            this.checkModification(astNode.getFirstDescendant(new AstNodeType[]{EcmaScriptGrammar.MEMBER_EXPRESSION}));
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.UNARY_EXPRESSION, EcmaScriptGrammar.POSTFIX_EXPRESSION}) && astNode.hasDirectChildren(new AstNodeType[]{EcmaScriptPunctuator.INC, EcmaScriptPunctuator.DEC})) {
            this.checkModification(astNode.getFirstDescendant(new AstNodeType[]{EcmaScriptGrammar.MEMBER_EXPRESSION}));
        }
    }

    private void checkFunction(AstNode astNode) {
        AstNode formalParameterList;
        AstNode identifier = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER});
        if (identifier != null && this.isEvalOrArguments(identifier.getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("function", identifier.getTokenValue()), identifier, new Object[0]);
        }
        if ((formalParameterList = astNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST})) != null) {
            for (int i = 0; i < formalParameterList.getNumberOfChildren(); i += 2) {
                identifier = formalParameterList.getChild(i);
                if (!this.isEvalOrArguments(identifier.getTokenValue())) continue;
                this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("parameter", identifier.getTokenValue()), identifier, new Object[0]);
            }
        }
    }

    private void checkVariableDeclaration(AstNode astNode) {
        AstNode identifier = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER});
        if (this.isEvalOrArguments(identifier.getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("variable", identifier.getTokenValue()), identifier, new Object[0]);
        }
    }

    private void checkPropertySetParameterList(AstNode astNode) {
        AstNode identifier = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER});
        if (this.isEvalOrArguments(identifier.getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("parameter", identifier.getTokenValue()), identifier, new Object[0]);
        }
    }

    private void checkModification(AstNode astNode) {
        if (this.isEvalOrArguments(astNode.getTokenValue()) && !astNode.hasDirectChildren(new AstNodeType[]{EcmaScriptPunctuator.LBRACKET}) && !astNode.getParent().is(new AstNodeType[]{EcmaScriptGrammar.CALL_EXPRESSION})) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove the modification of '" + astNode.getTokenValue() + "'.", astNode, new Object[0]);
        }
    }

    private static String createMessageFor(String name, String value) {
        return "Do not use '" + value + "' to declare a " + name + " - use another name.";
    }

    private boolean isEvalOrArguments(String name) {
        return "eval".equals(name) || "arguments".equals(name);
    }
}

