/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ExcessiveParameterList", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ExcessiveParameterListCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAXIMUM_FUNCTION_PARAMETERS = 7;
    @RuleProperty(key="maximumFunctionParameters", defaultValue="7")
    private int maximumFunctionParameters = 7;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST});
    }

    public void visitNode(AstNode node) {
        int numberOfParameters = this.getNumberOfParameters(node);
        if (numberOfParameters > this.maximumFunctionParameters) {
            this.getContext().createLineViolation((CodeCheck)this, "Function has {0,number,integer} parameters which is greater than {1,number,integer} authorized.", node, new Object[]{numberOfParameters, this.maximumFunctionParameters});
        }
    }

    private int getNumberOfParameters(AstNode node) {
        return (node.getNumberOfChildren() - 1) / 2 + 1;
    }

    public void setMaximumFunctionParameters(int threshold) {
        this.maximumFunctionParameters = threshold;
    }
}

