/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.CharsetAwareVisitor;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1451", priority=Priority.BLOCKER)
public class FileHeaderCheck
extends SquidCheck<LexerlessGrammar>
implements CharsetAwareVisitor {
    private static final String DEFAULT_HEADER_FORMAT = "";
    @RuleProperty(key="headerFormat", type="TEXT", defaultValue="")
    public String headerFormat = "";
    private Charset charset;
    private String[] expectedLines;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void init() {
        this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
    }

    public void visitFile(AstNode astNode) {
        List lines;
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        if (!FileHeaderCheck.matches(this.expectedLines, lines)) {
            this.getContext().createFileViolation((CodeCheck)this, "Add or update the header of this file.", new Object[0]);
        }
    }

    private static boolean matches(String[] expectedLines, List<String> lines) {
        boolean result;
        if (expectedLines.length <= lines.size()) {
            result = true;
            Iterator<String> it = lines.iterator();
            for (int i = 0; i < expectedLines.length; ++i) {
                String line = it.next();
                if (line.equals(expectedLines[i])) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

