/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1472", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class FunctionCallArgumentsOnNewLineCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.CALL_EXPRESSION});
    }

    public void visitNode(AstNode astNode) {
        for (AstNode args : astNode.getChildren(new AstNodeType[]{EcmaScriptGrammar.ARGUMENTS})) {
            int memberCallingLine = args.getPreviousSibling().getLastToken().getLine();
            if (args.getTokenLine() == memberCallingLine) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Make those call arguments start on line {0}", args, new Object[]{memberCallingLine});
        }
    }
}

