/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1219", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class NonCaseLabelInSwitchCheck
extends SquidCheck<LexerlessGrammar> {
    private boolean inCase;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.CASE_CLAUSE, EcmaScriptGrammar.LABELLED_STATEMENT});
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.inCase = false;
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.CASE_CLAUSE})) {
            this.inCase = true;
        } else if (this.inCase && astNode.is(new AstNodeType[]{EcmaScriptGrammar.LABELLED_STATEMENT})) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this misleading \"{0}\" label.", astNode, new Object[]{astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}).getTokenValue()});
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.CASE_CLAUSE})) {
            this.inCase = false;
        }
    }
}

