/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1125", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class BooleanEqualityComparisonCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.UNARY_EXPRESSION, EcmaScriptGrammar.EQUALITY_EXPRESSION, EcmaScriptGrammar.LOGICAL_AND_EXPRESSION, EcmaScriptGrammar.LOGICAL_OR_EXPRESSION});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.UNARY_EXPRESSION})) {
            this.checkUnaryExpression(astNode);
        } else {
            this.checkBinaryExpr(astNode);
        }
    }

    public void checkBinaryExpr(AstNode expr) {
        if (expr.getNumberOfChildren() == 3 && BooleanEqualityComparisonCheck.hasBooleanLiteral(expr)) {
            String operator = expr.getFirstChild(new AstNodeType[]{EcmaScriptPunctuator.EQUAL, EcmaScriptPunctuator.NOTEQUAL, EcmaScriptPunctuator.EQUAL2, EcmaScriptPunctuator.NOTEQUAL2, EcmaScriptPunctuator.ANDAND, EcmaScriptPunctuator.OROR}).getTokenValue();
            this.reportIssue(expr, operator);
        }
    }

    public static boolean hasBooleanLiteral(AstNode expr) {
        return BooleanEqualityComparisonCheck.isBooleanLiteral(expr.getFirstChild()) || BooleanEqualityComparisonCheck.isBooleanLiteral(expr.getLastChild());
    }

    public void checkUnaryExpression(AstNode unaryExpr) {
        if (unaryExpr.getFirstChild(new AstNodeType[]{EcmaScriptPunctuator.BANG}) != null && BooleanEqualityComparisonCheck.isBooleanLiteral(unaryExpr.getLastChild())) {
            this.reportIssue(unaryExpr, EcmaScriptPunctuator.BANG.getValue());
        }
    }

    public static boolean isBooleanLiteral(AstNode node) {
        return EcmaScriptKeyword.FALSE.getValue().equals(node.getTokenValue()) || EcmaScriptKeyword.TRUE.getValue().equals(node.getTokenValue());
    }

    public void reportIssue(AstNode node, String operator) {
        this.getContext().createLineViolation((CodeCheck)this, "Remove the useless \"{0}\" operator.", node, new Object[]{operator});
    }
}

