/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.HashSet;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="DuplicateFunctionArgument", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class DuplicateFunctionArgumentCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST});
    }

    public void visitNode(AstNode astNode) {
        HashSet values = Sets.newHashSet();
        for (int i = 0; i < astNode.getNumberOfChildren(); i += 2) {
            AstNode identifier = astNode.getChild(i);
            String value = identifier.getTokenValue();
            String unescaped = EscapeUtils.unescape(value);
            if (values.contains(unescaped)) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename or remove duplicate function argument '" + value + "'.", identifier, new Object[0]);
                continue;
            }
            values.add(unescaped);
        }
    }
}

